Group: Development/Java
AutoReq: yes,noosgi
BuildRequires: rpm-build-java-osgi
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-default
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%bcond_with bootstrap

Name:           junit
Epoch:          1
Version:        4.13.1
Release:        alt2
Summary:        Java regression test package
License:        EPL-1.0
URL:            http://www.junit.org/
BuildArch:      noarch

# ./generate-tarball.sh
Source0:        %{name}-%{version}.tar.gz
Source1:        generate-tarball.sh
Source2:        module-info.java

Patch1:         0001-Port-to-hamcrest-2.2.patch
Patch2:         0002-Add-JPMS-support-alt-patch.patch

BuildRequires:  maven-local
%if %{with bootstrap}
BuildRequires:  javapackages-bootstrap
%else
BuildRequires:  mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires:  mvn(org.apache.maven.plugins:maven-enforcer-plugin)
BuildRequires:  mvn(org.hamcrest:hamcrest-core)
%endif

# For other packages, surefire-junit4 is normally pulled as transitive
# runtime dependency of junit, but junit doesn't build-depend on
# itself, so explicit BR on surefire-junit4 is needed.
%if %{without bootstrap}
BuildRequires:  mvn(org.apache.maven.surefire:surefire-junit4)
%endif
Source44: import.info

Provides: junit = 0:%{version}
Provides: junit4 = %{epoch}:%{version}-%{release}
Conflicts: junit4 < 1:4.11-alt3_1jpp7
Obsoletes: junit4 < 1:4.11-alt3_1jpp7
Obsoletes: junit-junit4 < 1:4.11-alt3_1jpp7
Obsoletes: junit-junit3 < 1:3.8.2-alt9_10jpp6
Conflicts: junit-junit4 < 1:4.11-alt3_1jpp7
Conflicts: junit-junit3 < 1:3.8.2-alt9_10jpp6

%description
JUnit is a regression testing framework written by Erich Gamma and Kent Beck. 
It is used by the developer who implements unit tests in Java. JUnit is Open
Source Software, released under the Common Public License Version 1.0 and 
hosted on GitHub.

%package manual
Group: Development/Java
Summary:        Manual for %{name}
BuildArch: noarch

%description manual
Documentation for %{name}.

%package javadoc
Group: Development/Java
Summary:        Javadoc for %{name}
BuildArch: noarch

%description javadoc
Javadoc for %{name}.

%prep
%setup -q -n junit4-r%{version}

%autopatch -p1

cp %SOURCE2 src/main/java

# InaccessibleBaseClassTest fails with Java 8
sed -i /InaccessibleBaseClassTest/d src/test/java/org/junit/tests/AllTests.java

%pom_remove_plugin :replacer
sed s/@version@/%{version}/ src/main/java/junit/runner/Version.java.template >src/main/java/junit/runner/Version.java

%pom_remove_plugin :animal-sniffer-maven-plugin

# Removing hamcrest source jar references (not available and/or necessary)
%pom_remove_plugin :maven-javadoc-plugin

# Add proper Apache Felix Bundle Plugin instructions
# so that we get a reasonable OSGi manifest.
%pom_xpath_inject pom:project "<packaging>bundle</packaging>"
%pom_xpath_inject pom:build/pom:plugins "
    <plugin>
      <groupId>org.apache.felix</groupId>
      <artifactId>maven-bundle-plugin</artifactId>
      <extensions>true</extensions>
      <configuration>
        <instructions>
          <Bundle-SymbolicName>org.junit</Bundle-SymbolicName>
          <Export-Package>{local-packages},!org.hamcrest*,*;x-internal:=true</Export-Package>
          <_nouses>true</_nouses>
        </instructions>
      </configuration>
    </plugin>"

%mvn_file : %{name}

%mvn_alias junit:junit junit:junit-dep

%build
%mvn_build -- -P\!restrict-doclint -Dmaven.test.skip=true

%install
%mvn_install

%files -f .mfiles
%doc --no-dereference LICENSE-junit.txt
%doc README.md

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE-junit.txt

%files manual
%doc --no-dereference LICENSE-junit.txt
%doc doc/*

%changelog
