%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name:     jitterdebugger
Version:  0.3.1
Release:  alt1.70.gf7beb27
Summary:  Real time response messaurement tool
License:  MIT
Group:    System/Kernel and hardware
Url:      https://github.com/igaw/jitterdebugger

Source:   %name-%version.tar
BuildRequires: libhdf5-devel
BuildRequires: rpm-build-python3
BuildRequires: /usr/bin/h5cc

%description
jitterdebugger measures wake up latencies. jitterdebugger starts a thread
on each CPU which programs a timer and measures the time it takes from
the timer expiring until the thread which set the timer runs again.

This tool is a re-implementation of cyclictest. It doesn't have all the
command line options as cyclictest which results are easy to get wrong
and therefore an invalid latency report.

The default settings of jitterdebugger will produce a correct measurement
out of the box.

Furthermore, the tool supports storing all samples for post processing.

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS)
%make_build CFLAGS="%optflags"

%install
install -D jitterdebugger %buildroot%_bindir/jitterdebugger
install -D jitterplot     %buildroot%_bindir/jitterplot
install -D jittersamples  %buildroot%_bindir/jittersamples
install -D man/jitterdebugger.1 %buildroot%_man1dir/jitterdebugger.1
install -D man/jitterplot.1     %buildroot%_man1dir/jitterplot.1
install -D man/jittersamples.1  %buildroot%_man1dir/jittersamples.1

%files
%doc README.rst LICENSE CHANGELOG.md
%_bindir/jitterdebugger
%_bindir/jitterplot
%_bindir/jittersamples
%_man1dir/jitter*.1*

%changelog
