%define _unpackaged_files_terminate_build 1

Name: jackson-core
Version: 2.20.1
Release: alt2

Summary: Core part of Jackson
License: Apache-2.0
Group: Development/Java
Url: https://github.com/FasterXML/jackson-core
Vcs: https://github.com/FasterXML/jackson-core.git
BuildArch: noarch

Source0: %name-%version.tar
Patch0: 0001-Remove-fastdoubleparser-dep-alt-patch.patch

BuildRequires(pre): rpm-macros-java
BuildRequires: /proc
BuildRequires: rpm-build-java
BuildRequires: jpackage-default
BuildRequires: maven-local
BuildRequires: jackson-bom
BuildRequires: replacer
BuildRequires: maven-plugin-bundle
BuildRequires: moditect-maven-plugin

%description
Core part of Jackson that defines Streaming API as well
as basic shared abstractions.

%prep
%setup
%autopatch -p1

# Remove plugins unnecessary for RPM builds
%pom_remove_plugin ":maven-enforcer-plugin"
%pom_remove_plugin "org.jacoco:jacoco-maven-plugin"

# Remove shade plugin to get a jar with JPMS support.
%pom_remove_plugin ":maven-shade-plugin"

%pom_remove_dep ch.randelshofer:fastdoubleparser

%mvn_file : %name

%build
%mvn_build -f -j -- -Dmaven.compiler.source=1.8 -Dmaven.compiler.target=1.8 -Dmaven.javadoc.source=1.8 -Dmaven.compiler.release=8

%install
%mvn_install

%files -f .mfiles
%doc README.md release-notes/*
%doc --no-dereference LICENSE

%changelog
