%def_enable check

Name: iso-codes
Version: 4.19.0
Release: alt1

Group: System/Internationalization
Summary: ISO code lists and translations
License: LGPL-2.1
Url: https://salsa.debian.org/iso-codes-team/iso-codes

Vcs: https://salsa.debian.org/iso-codes-team/iso-codes.git

Source: %name-%version.tar
BuildArch: noarch

BuildRequires: common-licenses python3-base

%description
This package provides several ISO standards:
 * ISO-639   language code list,
 * ISO-3166  territory code list, and ISO-3166-2 sub-territory lists,
 * ISO-4217  currency names and code elements,
 * ISO-15924 codes for the representation of names of scripts
and all their translations in gettext .po form.

%package devel
Summary: Files for development using %name
Group: Development/Other
Requires: %name = %version-%release

%description devel
This package contains the pkg-config files for development
when building programs that use %name

%prep
%setup
ln -sf %_licensedir/LGPL-2.1 LICENSE

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std
%find_lang --all-name iso --output=%name.lang

%check
%make check

%files -f %name.lang
%doc CHANGELOG* README.md TODO
%doc --no-dereference LICENSE
%_datadir/xml/%name/
%_datadir/%name/json/

%files devel
%_datadir/pkgconfig/iso-codes.pc

%changelog
