%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%define oname ipython

%def_without doc
%def_with check

Name: ipython3
Version: 9.7.0
Release: alt1
Summary: An enhanced interactive Python 3 shell
License: BSD-3-Clause
Group: Development/Python3
Url: https://ipython.org
Vcs: https://github.com/ipython/ipython.git

BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(prompt_toolkit)
BuildRequires: python3(stack_data)
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
BuildRequires: python3(pytest)
BuildRequires: python3(pytest-asyncio)
BuildRequires: python3(testpath)
BuildRequires: python3(traitlets)
BuildRequires: python3(pygments)
BuildRequires: python3(pexpect)
BuildRequires: python3-modules-sqlite3
BuildRequires: python3(jedi)
BuildRequires: python3(pickleshare)
BuildRequires: /dev/pts
BuildRequires: /proc
BuildRequires: git
%endif

%if_with doc
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx-sphinx-build-symlink
BuildRequires: python3(sphinx_rtd_theme)
BuildRequires: python3(ipykernel)
BuildRequires: python3(matplotlib)
BuildRequires: python3-module-matplotlib-inline
BuildRequires: python3-module-matplotlib-tk
BuildRequires: python3(stack_data)
BuildRequires: python3(exceptiongroup)
BuildRequires: python3(testpath)
BuildRequires: python3(numpy)
BuildRequires: python3(prompt_toolkit)
BuildRequires: python3(pickleshare)
BuildRequires: python3(jedi)
BuildRequires: python3-module-matplotlib-sphinxext
BuildRequires: python3-module-sphinx-devel
BuildRequires: /proc
# Some trouble with graphviz generating 'Inheritance diagram'
#BuildRequires: graphviz
%endif

# skip traitlets.eventful
%add_findreq_skiplist %python3_sitelibdir/IPython/utils/eventful.py
# skip jupyter_client.jsonutil
%add_findreq_skiplist %python3_sitelibdir/IPython/utils/jsonutil.py
# skip OpenGL.*
%add_findreq_skiplist %python3_sitelibdir/IPython/terminal/pt_inputhooks/glut.py

%add_python3_req_skip System clr gobject gtk msvcrt
%add_python3_req_skip wx
%add_python3_req_skip setuptools
# nessesary for IPython/sphinxext dir
%add_python3_req_skip sphinx sphinx.util

Requires: python3-module-%oname = %EVR

Conflicts: ipython

%description
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

Main features:
* Comprehensive object introspection.
* Input history, persistent across sessions.
* Caching of output results during a session with automatically generated
  references.
* Readline based name completion.
* Extensible system of 'magic' commands for controlling the environment and
  performing many tasks related either to IPython or the operating system.
* Configuration system with easy switching between different setups (simpler
  than changing $$PYTHONSTARTUP environment variables every time).
* Session logging and reloading.
* Extensible syntax processing for special purpose situations.
* Access to the system shell with user-extensible alias system.
* Easily embeddable in other Python programs.
* Integrated access to the pdb debugger and the Python profiler.

%package doc
Summary: IPython documentation
Group: Development/Python3

%description doc
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

This package contains IPython documentation (html and PDF formats).

%package examples
Summary: IPython examples
Group: Development/Python3

%description examples
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

This package contains examples for IPython.

%package -n python3-module-%oname
Summary: An enhanced interactive Python 3 shell
Group: Development/Python3
Requires: python3(matplotlib_inline) python3(pickleshare)

%description -n python3-module-%oname
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

This package contains modules for Python-3.

%prep
%setup

%if_with doc
%prepare_sphinx3 docs
ln -s ../objects.inv docs/source/
%endif

%build
%pyproject_build

%install
%pyproject_install

%if_with doc
install -d %buildroot%_docdir/%name
cp docs/source/*.txt %buildroot%_docdir/%name/

export PYTHONPATH=%buildroot%python3_sitelibdir
%make -C docs html
cp -R docs/build/html/* examples %buildroot%_docdir/%name/
%endif

%check
# Scale timeouts 4 times
export IPYTHON_TESTING_TIMEOUT_SCALE=4
%pyproject_run_pytest -v tests/

%files
%doc COPYING.rst LICENSE
%doc README.rst
%_bindir/*
%_man1dir/*
%if_with doc
%dir %_docdir/%name
%_docdir/%name/*.txt
%endif

%files -n python3-module-%oname
%python3_sitelibdir/IPython
%python3_sitelibdir/%oname-%version.dist-info

%if_with doc
%files doc
%_docdir/%name
%exclude %_docdir/%name/*.txt
%exclude %_docdir/%name/examples

%files examples
%dir %_docdir/%name
%_docdir/%name/examples
%endif

%changelog
