%define soversion 2
%define llvmversion 15
%define optflags_lto %nil

%set_verify_elf_method skip

Name: intel-graphics-compiler
Version: 2.18.5
Release: alt1
Summary: Intel Graphics Compiler for OpenCL
License: MIT
Group: Development/C++
URL: https://github.com/intel/intel-graphics-compiler

Source: %name-%version.tar

Patch1: %name-2.11.2-alt-build.patch
# our -Wall triggers -Werror for everything
Patch2: %name-alt-disable-werror.patch

BuildRequires(pre): rpm-build-cmake ninja-build

BuildRequires: flex
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: python3-module-mako
BuildRequires: python3-module-yaml
BuildRequires: spirv-headers
BuildRequires: spirv-tools
BuildRequires: clang%llvmversion.0
BuildRequires: lld%llvmversion.0-devel
BuildRequires: libspirv-tools-devel
BuildRequires: libspirv-llvm%llvmversion.0-translator-devel
BuildRequires: llvm%llvmversion-spirv
BuildRequires: llvm%llvmversion.0-devel
BuildRequires: llvm%llvmversion.0-polly
BuildRequires: libpolly%llvmversion.0-devel
BuildRequires: mlir%llvmversion.0-tools
BuildRequires: libmlir%llvmversion.0-devel
BuildRequires: libvc-intrinsics-devel
BuildRequires: libvc-intrinsics-devel-static
BuildRequires: libintel-opencl-clang%llvmversion-devel
BuildRequires: zlib-devel

ExclusiveArch: x86_64

%description
Intel Graphics Compiler for OpenCL.

%package -n libigc%soversion
Summary: Library for Intel Graphics Compiler
Group: System/Libraries

%description -n libigc%soversion
An LLVM based compiler for OpenCL targeting Intel Gen graphics hardware
architecture.

%package -n libigc-devel
Summary: Headers for the Intel Graphics Compiler library
Group: System/Libraries
Requires: libigc%soversion = %EVR

%description -n libigc-devel
This package contains development files for libigc.

%package -n libigc-tools
Summary:  Tools for the Intel Graphics Compiler library
Group: Development/Tools
Requires: libigc%soversion = %EVR

%description -n libigc-tools
This package includes tools for the media driver.

%package -n libigdfcl%soversion
Summary: Intel Graphics Frontend Compiler library
Group: System/Libraries

%description -n libigdfcl%soversion
Library files for the Intel Graphics Frontend Compiler.

%package -n libigdfcl-devel
Summary: Headers for the Intel Graphics Frontend Compiler library
Group: System/Libraries
Requires: libigdfcl%soversion = %EVR

%description -n libigdfcl-devel
This package contains development files for libigdfcl.

%prep
%setup
%autopatch1 -p1

%build
export ALTWRAP_LLVM_VERSION=%llvmversion.0
%cmake -GNinja \
  -DLLVM_DIR=%_prefix/lib/llvm-%llvmversion.0/%_lib/cmake/llvm \
  -DIGC_OPTION__LLDELF_LIB_DIR=%_prefix/lib/llvm-%llvmversion.0/%_lib/ \
  -DLLD_INCLUDE_DIR=%_prefix/lib/llvm-%llvmversion.0/include/lld \
  -DCMAKE_BUILD_TYPE=Release \
  -Wno-dev \
  -DIGC_OPTION__ARCHITECTURE_TARGET='Linux64' \
  -DIGC_OPTION__SPIRV_TOOLS_MODE=Prebuilds \
  -DIGC_OPTION__VC_INTRINSICS_MODE=Prebuilds
%cmake_build

%install
%cmake_install

pushd %buildroot%_libdir
ln -sf libigc.so.%soversion libigc.so
ln -sf libiga64.so.%soversion libiga64.so
ln -sf libigdfcl.so.%soversion libigdfcl.so
popd

%files -n libigc%soversion
%_libdir/libigc.so.%soversion
%_libdir/libigc.so.%soversion.*
%_libdir/libiga64.so.%soversion
%_libdir/libiga64.so.%soversion.*
%_libdir/igc2/NOTICES.txt

%files -n libigc-devel
%_libdir/libigc.so
%_includedir/igc
%_libdir/libiga64.so
%_includedir/iga

%files -n libigc-tools
%_bindir/iga64

%files -n libigdfcl%soversion
%_libdir/libigdfcl.so.%soversion
%_libdir/libigdfcl.so.%soversion.*

%files -n libigdfcl-devel
%_libdir/libigdfcl.so
%_includedir/visa
%_libdir/pkgconfig/igc-opencl.pc

%changelog
