%define _unpackaged_files_terminate_build 1
%define pname integalert

# Using ifarch instead of ExclusiveArch tag in order to make
# the other packages available on non-PVE arches.
%ifarch x86_64 aarch64
%def_with pve
%else
%def_without pve
%endif

%{!?_rundir: %global _rundir /run}

Name:     %pname-source
Epoch:    1
Version:  0.5.1
Release:  alt4

Summary:  Osec-based integrity checking script and settings
License:  GPLv2
Group:    Monitoring
Url:      http://git.altlinux.org/people/manowar/packages/integalert.git

Packager: Paul Wolneykien <manowar@altlinux.org>
Source:   %name-%version.tar

%ifnarch %e2k
BuildRequires: shellcheck
%endif

%description
Osec-based integrity checking script and settings.

%package -n %pname
Summary:  Osec-based integrity checking script and settings
Group:    Monitoring
BuildArch: noarch

Requires: systemd
Requires: osec-cronjob >= 1.3.1-alt2

Obsoletes: integ < %EVR
Provides:  integ = %EVR
Conflicts: integ

%description -n %pname
Osec-based integrity checking script and settings.
Includes the 'integalert.service' that is configured to run
before 'sysinit.target' on every boot.

Activates the special 'integ-check-failed.target' on failure.

%package -n installer-feature-integalert-stage2
Summary: Run integrity check after install (installer files)
Group: System/Configuration/Other
BuildArch: noarch

%description -n installer-feature-integalert-stage2
Run integrity check after install (installer files).

%package -n installer-feature-integalert-stage3
Summary: Run integrity check after install (chroot files)
Group: System/Configuration/Other
Requires: integalert = %version-%release
BuildArch: noarch

%description -n installer-feature-integalert-stage3
Run integrity check after install (chroot files).

%package -n %pname-vm-check
Summary: Run VM integrity check before PVE and/or Libvirtd start and then every 5 mins
Group: Monitoring
BuildArch: noarch

%description -n %pname-vm-check
Includes a service that is configured to run 'integalert vm' and
'integalert container' before 'pvedaemon.service' and
'libvirtd.service', and every 5 mins after that (using a timer).

Activates the special 'vm-check-failed.target' on failure.

%package -n %pname-trigger-pve
Summary: Lock down PVE cluster VMs on integrity failure
Group: Monitoring
# For 'qm block' command:
Requires: pve-qemu-server >= 7.4.3-alt3

%description -n %pname-trigger-pve
Lock down PVE cluster VMs on integalert_vm.service failure.

%prep
%setup

%build
%make_build sbindir=%_sbindir sysconfdir=%_sysconfdir datadir=%_datadir unitdir=%_unitdir rundir=%_rundir presetdir=%_presetdir WITH_PVE=%{with pve} logrotatedir=%_logrotatedir mandir=%_mandir man8dir=%_man8dir sharedstatedir=%_sharedstatedir logdir=%_logdir libexecdir=%_libexecdir

%install
%makeinstall_std sbindir=%_sbindir sysconfdir=%_sysconfdir datadir=%_datadir unitdir=%_unitdir rundir=%_rundir presetdir=%_presetdir WITH_PVE=%{with pve} logrotatedir=%_logrotatedir mandir=%_mandir man8dir=%_man8dir sharedstatedir=%_sharedstatedir logdir=%_logdir libexecdir=%_libexecdir

# For ghost:
mkdir -p %buildroot%_sysconfdir/sysconfig
touch %buildroot%_sysconfdir/sysconfig/integalert

%check
%ifnarch %e2k
shellcheck %pname -e SC1090,SC1091 -e SC2155,SC2166,SC3043
%endif

%post -n %pname
%post_service %pname

%preun -n %pname
%preun_service %pname

%post -n %pname-vm-check
%post_service integalert_vm

%preun -n %pname-vm-check
%preun_service integalert_vm

%files -n installer-feature-integalert-stage2
%_datadir/install2/postinstall.d/90-integrity-init.sh

%files -n installer-feature-integalert-stage3

%files -n %pname
%_unitdir/integalert.service
%_unitdir/integ-check-failed.target
%_presetdir/*
%_sbindir/integalert
%dir %_sysconfdir/osec/integalert*
%config(noreplace) %_sysconfdir/osec/integalert*/*.conf
%config(noreplace) %_sysconfdir/osec/integalert.conf
%_libexecdir/integalert/sender
%dir %_sysconfdir/osec/integalert*/trigger.d
%config(noreplace) %_logrotatedir/integalert*.conf
%ghost %_sysconfdir/sysconfig/integalert
%_man8dir/*.8.*

%files -n %pname-vm-check
%_unitdir/integalert_vm.service
%_unitdir/vm-check-failed.target
%_unitdir/integalert_vm.timer

%if_with pve
%files -n %pname-trigger-pve
%_sysconfdir/osec/integalert_vm/trigger.d/*-pve-*
%endif

%changelog
