# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: ima-evm-utils
Version: 1.6.2
Release: alt1

Summary: IMA/EVM support utilities
License: GPL-2.0-or-later
Group: System/Configuration/Other

Url: http://linux-ima.sourceforge.net/
Vcs: https://git.code.sf.net/p/linux-ima/ima-evm-utils
# Docs: https://sourceforge.net/p/linux-ima/wiki/Home/
# Manual: https://en.opensuse.org/SDB:Ima_evm

# Repacked http://sourceforge.net/projects/linux-ima/files/ima-evm-utils/%name-%version.tar.gz
Source: %name-%version.tar

BuildRequires: asciidoc
BuildRequires: docbook-style-xsl
BuildRequires: libattr-devel
BuildRequires: libkeyutils-devel
BuildRequires: libssl-devel
BuildRequires: libtpm2-tss-devel
BuildRequires: xsltproc
%{?!_without_check:%{?!_disable_check:
BuildRequires: attr
BuildRequires: e2fsprogs
BuildRequires: fsverity-utils
BuildRequires: openssl
BuildRequires: rpm-build-vm >= 1.51
BuildRequires: xxd
}}

Requires: libimaevm = %EVR

%description
The Trusted Computing Group(TCG) run-time Integrity Measurement Architecture
(IMA) maintains a list of hash values of executables and other sensitive
system files, as they are read or executed. These are stored in the file
systems extended attributes. The Extended Verification Module (EVM) prevents
unauthorized changes to these extended attributes on the file system.
ima-evm-utils is used to prepare the file system for these extended attributes.

(This package contains IMA/EVM utilities.)

%package -n libimaevm
Summary: IMA/EVM libraries
License: LGPL-2.0-or-later
Group: System/Libraries

%description -n libimaevm
The Trusted Computing Group(TCG) run-time Integrity Measurement Architecture
(IMA) maintains a list of hash values of executables and other sensitive
system files, as they are read or executed. These are stored in the file
systems extended attributes. The Extended Verification Module (EVM) prevents
unauthorized changes to these extended attributes on the file system.
ima-evm-utils is used to prepare the file system for these extended attributes.

(This package contains libimaevm library.)

%package -n libimaevm-devel
Summary: Development files for applications which use libimaevm
License: LGPL-2.0-or-later
Group: Development/C

%description -n libimaevm-devel
The Trusted Computing Group(TCG) run-time Integrity Measurement Architecture
(IMA) maintains a list of hash values of executables and other sensitive
system files, as they are read or executed. These are stored in the file
systems extended attributes. The Extended Verification Module (EVM) prevents
unauthorized changes to these extended attributes on the file system.
ima-evm-utils is used to prepare the file system for these extended attributes.

(This package contains headers and development files.)

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure --disable-static
%make_build

%install
%makeinstall_std doc_DATA=

%check
LD_LIBRARY_PATH=%buildroot%_libdir %buildroot%_bindir/evmctl --version

unset TMPDIR
vm-run --kvm=cond --sbin --ext4=verity make check VERBOSE=1

%files
%doc NEWS README AUTHORS LICENSES.txt examples/*.sh doc/sf/sf-wiki.md
%_bindir/*
%_man1dir/*

%files -n libimaevm
%_libdir/libimaevm.so.*

%files -n libimaevm-devel
%_includedir/*
%_libdir/libimaevm.so

%changelog
