# -*- mode: rpm-spec; coding: utf-8 -*-
%define realname icewm
# Choose markdown or asciidoc to generate manual html
%def_with markdown

Name: icewm
Version: 3.9.0
Release: alt1
Epoch:3

Summary: X11 Window Manager
Group: Graphical desktop/Icewm
License: LGPLv2
Url: https://ice-wm.org
Packager: Dmitriy Khanzhin <jinn@altlinux.org>

%define _icewmdocdir %_datadir/doc/%realname-%version

Provides: %realname-githubmod = %version-%release
Provides: %realname-light = %version-%release
Requires: design-%realname >= 1.0-alt12
Obsoletes: %realname-githubmod < %version-%release
Obsoletes: %realname-light < %version-%release

Source0: %realname-%version.tar
Source2: %realname.menu-method
Source3: %realname-16.png
Source4: %realname-32.png
Source5: %realname-48.png
Source6: start%realname
Source7: IceWM.xpm
Source8: %realname.wmsession
Source9: README.ALT
Source12: icewm-old-changelog.bz2

Patch0: %realname-%version-%release.patch

BuildRequires(pre): rpm-macros-cmake

# Automatically added by buildreq on Thu Sep 04 2025
BuildRequires: cmake gcc-c++ imlib2-devel libSM-devel libXcomposite-devel
BuildRequires: libXcursor-devel libXdamage-devel libXft-devel libXinerama-devel
BuildRequires: libXrandr-devel libXres-devel libalsa-devel libao-devel
BuildRequires: libfribidi-devel librsvg-devel libsndfile-devel
BuildRequires: perl-Pod-Html perl-Pod-Usage
%if_with markdown
BuildRequires: discount
%else
BuildRequires: asciidoctor
%endif

%description
 Window Manager for X Window System. Can emulate the look of Windows'95, OS/2
Warp 3,4, Motif or the Java Metal GUI. Tries to take the best features of the
above systems. Features multiple workspaces, opaque move/resize, task bar,
window list, mailbox status, digital clock. Fast and small.
 This release is based on alternative source, based on a community fork
maintained on Github https://github.com/bbidulock/icewm

Recommends: iftop, mutt

%package menu-method
Summary: Menu-method to create old style IceWM menu
Group: Graphical desktop/Icewm
BuildArch: noarch

Requires: %realname = %EVR

%description menu-method
This package contains menu-method to create old style IceWM menu

%package themes
Summary: Extra themes for IceWM
Group: Graphical desktop/Icewm
BuildArch: noarch

Requires: design-%realname >= 1.0-alt12
Conflicts: design-%realname-themes <= 1.0-alt5

%description themes
This package contains extra themes that included to IceWM distribution

%prep
%setup
%patch0 -p1

%build
%cmake	-DPREFIX=%_prefix \
	-DCFGDIR=%_x11sysconfdir/%realname \
	-DLIBDIR=%_x11x11dir/%realname \
	-DDOCDIR=%_icewmdocdir \
	-DCONFIG_IMLIB2=on \
	-DCONFIG_LIBRSVG=on \
	-DCONFIG_GUIEVENTS=on \
	-DICESOUND="AO,ALSA,OSS" \
	-DENABLE_LTO=on \
	-DXTERMCMD=xvt \
	-DCONFIG_DEFAULT_THEME="AltClearlooks/default.theme" \
	-DCONFIG_DEFAULT_BACKGROUND="/usr/share/design/current/backgrounds/default.png" \
	-DICEHELPIDX=%_icewmdocdir/ru/icewm.html \
	-DTRANSLANG=ru
%cmake_build

%install
# This step seems to be necessary for some reason. Executables have to be
# relinked before installation into buildroot; cmake --install alone does not
# invoke the re-link step.
DESTDIR=%buildroot %cmake_build -t install
%cmake_install

mkdir -p %buildroot%_x11sysconfdir/%realname
for i in menu menu.lock; do touch %buildroot%_x11sysconfdir/%realname/$i; done
install -pD -m755 %SOURCE2 %buildroot%_sysconfdir/menu-methods/%realname
install -pD -m644 %SOURCE3 %buildroot%_miconsdir/%realname.png
install -pD -m644 %SOURCE4 %buildroot%_niconsdir/%realname.png
install -pD -m644 %SOURCE5 %buildroot%_liconsdir/%realname.png
install -pD -m644 %SOURCE7 %buildroot%_pixmapsdir/IceWM.xpm
install -pD -m644 %SOURCE8 %buildroot%_x11sysconfdir/wmsession.d/04IceWM
install -m644 %SOURCE9 README.ALT
install -m644 %SOURCE12 %buildroot%_icewmdocdir/icewm-old-changelog.bz2
install -m644 AUTHORS %buildroot%_icewmdocdir/AUTHORS
install -m644 NEWS %buildroot%_icewmdocdir/NEWS
install -m644 README.md %buildroot%_icewmdocdir/README.md
install -m755 %SOURCE6 %buildroot%_bindir/start%realname

%find_lang %realname

# remove unpackaged files
rm -f %buildroot/%_bindir/%realname-set-gnomewm
rm -f %buildroot/%_datadir/xsessions/%realname.desktop

%post
if [ ! -f %_x11sysconfdir/%realname/menu.lock ]
then
  if [ -f %_x11sysconfdir/%realname/menu ]
  then
    rm -f %_x11sysconfdir/%realname/menu
  fi
  cp -f %_x11x11dir/%realname/menu %_x11sysconfdir/%realname/menu
fi

%pre menu-method
if [ $1 -eq 1 ]
  then
  if [ -e %_x11sysconfdir/%realname/menu ]
    then mv -f %_x11sysconfdir/%realname/menu %_x11sysconfdir/%realname/menu.save
  fi
fi

%postun menu-method
if [ $1 -eq 0 ]
  then
  if [ -e %_x11sysconfdir/%realname/menu.save ]
    then mv -f %_x11sysconfdir/%realname/menu.save %_x11sysconfdir/%realname/menu
  fi
fi

%files -f %realname.lang
%dir %_x11sysconfdir/%realname
%ghost %_x11sysconfdir/%realname/*
%_x11sysconfdir/wmsession.d/*
%_bindir/*
%dir %_x11x11dir/%realname
%_x11x11dir/%realname/*
%exclude %_x11x11dir/%realname/themes/*
%_niconsdir/*
%_miconsdir/*
%_liconsdir/*
%_pixmapsdir/*
%_man1dir/*
%_man5dir/*
%_mandir/ru/*
%_datadir/xsessions/*.desktop
%dir %_icewmdocdir
%_icewmdocdir/*

%files menu-method
%config(noreplace) %_sysconfdir/menu-methods/*

%files themes
%_x11x11dir/%realname/themes/*

%changelog
