%def_without static

Name: hwinfo
Version: 25.0
Release: alt1

Summary: Hardware detection tool
License: GPLv2
Group: System/Kernel and hardware

URL: https://github.com/opensuse/hwinfo
#http://download.opensuse.org/source/factory/repo/oss/suse/src
# http://download.opensuse.org/source/factory/repo/oss/suse/src/%name-%version-2.1.src.rpm
Source: %name-%version.tar
Patch0: %name-14.19-kbd.c-tiocgdev_undefined.patch
Patch1: %name-21.23-as-needed.patch
Patch2: %name-21.23-makefile.patch
Patch3: %name-14.19-alt.patch
Patch4: %name-alt-no-hal.patch
Patch5: hwinfo-21.23-perl522.patch
Patch3500: hwinfo-loongarch64.patch

%define lname lib%name
Requires: %lname = %version-%release

# Automatically added by buildreq on Thu Sep 25 2008 (-bi)
BuildRequires: doxygen flex perl-XML-Parser perl-XML-Writer perl-devel
BuildRequires: rpm-build-licenses
BuildRequires: libdbus-devel
BuildRequires: pkg-config
BuildRequires: pkgconfig(udev)
BuildRequires: pkgconfig(uuid)
%ifarch %ix86 x86_64
BuildRequires: libx86emu-devel
%endif

%description
A simple program that lists results from the hardware detection
library.


%package utils
Summary: Hardware Detection utils
Group: System/Kernel and hardware

%description utils
Hardware Detection utils.


%package -n %lname
Summary: Hardware Detection library
Group: System/Libraries
Provides: libhd = %version-%release

%description -n %lname
This library collects information about the hardware installed on a
system.


%package -n %lname-doc
Summary: Documentation for Hardware Detection library
Group: Documentation
BuildArch: noarch
Conflicts: %name-devel < %version-%release

%description -n %lname-doc
Documentation for Hardware Detection library.


%package -n %lname-devel
Summary: Hardware Detection library (development files)
Group: Development/C
Obsoletes: %name-devel < %version-%release
Provides: %name-devel = %version-%release
Provides: libhddev
Requires: %lname = %version-%release

%description -n %lname-devel
Development files for %lname.


%if_with static
%package -n %lname-devel-static
Summary: Hardware Detection static library
Group: Development/C
Requires: %lname-devel = %version-%release
Conflicts: %name-devel < %version-%release

%description -n %lname-devel-static
This static library collects information about the hardware installed
on a system.
%endif


%prep
%setup
#patch0 -p1
%patch1 -p0
#patch2 -p1
%patch3 -p1
%patch4 -p2
#patch5 -p2
%patch3500 -p1


%build
%ifarch %e2k
sed -i 's/arch_aarch64/&, arch_e2k/' src/hd/hd.h
sed -i 's/aarch64/e2k/' src/hd/hd.c
sed -i 's/ -MG / /' Makefile.common
(cd src/hd; make version.h)
%endif
%make RPM_OPT_FLAGS="%optflags" 
%make_build doc
bzip2 --best --keep --force changelog


%install
%make DESTDIR=%buildroot LIBDIR=%_libdir install
install -d -m 0755 %buildroot{%_man8dir,%_docdir/%lname-%version/html,%_localstatedir/hardware/udi}
install -m 0644 doc/*.8 %buildroot%_man8dir/
install -m 0644 doc/libhd/html/* %buildroot%_docdir/%lname-%version/html/
%{?_with_static:install -m 0644 src/lib*.a %buildroot%_libdir/}


%files
%doc changelog.* README*
%_sbindir/%name
%_man8dir/*


%files utils
%_sbindir/getsysinfo
%_sbindir/mk_isdnhwdb
%_sbindir/check_hd
%_sbindir/convert_hd


%files -n %lname
%_libdir/*.so.*
%dir %_localstatedir/hardware
%dir %_localstatedir/hardware/udi
%_datadir/%name


%files -n %lname-devel
%_libdir/*.so
%_pkgconfigdir/*
%_includedir/*


%files -n %lname-doc
%_docdir/%lname-%version/html


%if_with static
%files -n %lname-devel-static
%_libdir/*.a
%endif


%changelog
