%def_enable openvz
%def_enable unicode
%def_enable taskstats
%def_enable sensors

Name: htop
Version: 3.4.1
Release: alt1

Summary: Interactive ncurses-based process viewer for Linux
License: GPLv2+
Group: Monitoring

Url: http://hisham.hm/htop/
Source0: %name-%version.tar
Source1: %name.ru.1
Patch: htop-3.0.5-alt-colorscheme.patch

BuildRequires: libncursesw-devel
BuildRequires: python3
BuildRequires: /proc
BuildRequires: libsensors3-devel 
%{?!_with_bootstrap:BuildRequires: ImageMagick-tools}

%define rman1dir %_mandir/ru/man1

Summary(ru_RU.UTF-8): Интерактивный просмотр списка запущенных процессов

%description
%name is similar to top, but allows to scroll the list vertically
and horizontally to see all processes and their full command lines.

Tasks related to processes (killing,  renicing)
can be done without entering their PIDs.

%description -l ru_RU.UTF-8
%name служит для просмотра списка запущенных процессов.
По сравнению с классическим top он усовершенствован следующим образом:

  * если список процессов не влезает в экран по высоте,
    его можно пролистывать вверх/вниз,
  * если информация о процессе не влезает в экран по ширине,
    её можно прокручивать вправо/влево,
  * действия над процессами (смена приоритета, удаление)
    не требуют вручную вводить идентификатор процесса (PID),
  * возможны действия над группами процессов.

htop использует для работы с экраном библиотеку ncurses.

%package desktop
Summary: Dektop file to %name
Group:  Monitoring
BuildArch: noarch
License: GPL-3.0-or-later
Requires: %name >= %version

%description desktop
Dektop files for %name

%description desktop -l ru_RU.UTF-8
Файлы для запуска %name из меню

%prep
%setup
#patch -p1

# fix shebang
#sed -i 's|#!/usr/bin/env python|#!/usr/bin/python2|' scripts/MakeHeader.py

%build
%autoreconf
%configure -C \
	%{subst_enable openvz} \
	%{subst_enable unicode} \
	%{subst_enable taskstats} \
	%{subst_enable sensors}
%make_build

%install
%makeinstall_std
install -pDm644 %SOURCE1 %buildroot%rman1dir/%name.1
install -pDm644 %name.png %buildroot%_iconsdir/hicolor/128x128/apps/%name.png

%if_with bootstrap
%else
mkdir -p %buildroot%_niconsdir
convert %name.png -resize 32x32 %buildroot%_niconsdir/%name.png
rm -r %buildroot%_pixmapsdir/
%endif

%files
%_bindir/%name
%_man1dir/%name.1*
%rman1dir/%name.1*
%doc AUTHORS README ChangeLog

%files desktop
%_desktopdir/%name.*
%{?!_with_bootstrap:%_niconsdir/%name.*}
%_iconsdir/hicolor/128x128/apps/%name.png
%_datadir/icons/hicolor/scalable/apps/%{name}.svg


%changelog
