%define _unpackaged_files_terminate_build 1
%def_with check

Name: hamcrest
Version: 3.0
Release: alt1

Summary: Library of matchers for building test expressions
License: BSD-3-Clause
Group: Development/Java
Url: http://hamcrest.org
Vcs: https://github.com/hamcrest/JavaHamcrest.git
BuildArch: noarch

Source0: %name-%version.tar
Patch0: 0001-Remove-unwanted-gradle-plugins-alt-patch.patch

Provides: hamcrest-core = %EVR
Provides: hamcrest-library = %EVR

BuildRequires(pre): rpm-macros-gradle
BuildRequires: /proc
BuildRequires: rpm-build-java-osgi
BuildRequires: jpackage-17-compat
BuildRequires: xgradle
BuildRequires: biz-aQute-bnd-gradle-plugins
%if_with check
BuildRequires: junit5
%endif

%description
Provides a library of matcher objects (also known as constraints or predicates)
allowing 'match' rules to be defined declaratively, to be used in other
frameworks. Typical scenarios include testing frameworks, mocking libraries and
UI validation rules.

%{?javadoc_package}

%prep
%setup
%autopatch -p1

# Disable the hamcrest-integration module as very obsolete.
sed -i '/^[[:space:]]*'\''hamcrest-integration'\''/d' settings.gradle

# Aliases for compatibility.
%mvn_alias org.hamcrest:hamcrest \
  org.hamcrest:hamcrest-core \
  org.hamcrest:hamcrest-library \
  #

%build
%gradle_publish

%install
# Hamcrest library and core have almost empty jars and were deprecated
# use org.hamcrest:hamcrest as a dependency instead.
%gradle_register --artifacts=hamcrest-%version
%gradle_register_javadoc --artifacts=hamcrest-%version

%gradle_install

%check
%gradle_check -Dfile.encoding=UTF-8

%files -f .mfiles
%doc README.md
%doc --no-dereference LICENSE

%changelog
