%define pypi_name h5py
%define mod_name %pypi_name

# disable tests on 32bit architectures
%ifnarch %ix86 armh
%def_with check
%else
%def_without check
%endif

%define descr \
The h5py package provides both a high- and low-level interface to the HDF5 \
library from Python. The low-level interface is intended to be a complete \
wrapping of the HDF5 API, while the high-level component supports access to HDF5 \
files, datasets and groups using established Python and NumPy concepts.

Name: %pypi_name
Version: 3.15.1
Release: alt1
Summary: Read and write HDF5 files from Python
License: BSD-3-Clause
Group: Development/Python3
Url: http://www.h5py.org/
Vcs: https://github.com/h5py/h5py
Source: %name-%version.tar
# custom ipython completer for ipython session
%filter_from_requires /python3(IPython\(\..*\)\?)/d
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-Cython
BuildRequires: python3-module-oldest-supported-numpy
BuildRequires: python3-module-pkgconfig
BuildRequires: libhdf5-devel
BuildRequires: liblzf-devel
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-mpi
%endif

%description
%descr

%package -n python3-module-%name
Summary: %summary
Group: Development/Python3
%add_python3_req_skip Tkinter

%description -n python3-module-%name
%descr

%package -n python3-module-%name-tests
Summary: Tests for %name
Group: Development/Python3
Requires: python3-module-%name = %EVR

%description -n python3-module-%name-tests
This package contains tests for %name.

%prep
%setup

%build
%add_optflags -fno-strict-aliasing
# build against system lzf library
export H5PY_SYSTEM_LZF=1
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- bash -s <<-'ENDTESTS'
set -eu
mkdir empty
cd empty
python -m pytest -ra -Wignore --pyargs %pypi_name
ENDTESTS

%files -n python3-module-%name
%doc README.*
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir/*/tests

%files -n python3-module-%name-tests
%python3_sitelibdir/*/tests

%changelog
