%define _unpackaged_files_terminate_build 1

Name:    gz-fuel-tools
Version: 10.0.0
Release: alt2

Summary: A client library and command line tools for interacting with Gazebo Fuel servers
License: Apache-2.0
Group:   Development/C++
Url:     https://github.com/gazebosim/gz-fuel-tools

Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %name-%version.tar

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires: gcc-c++
BuildRequires: gz-cmake
BuildRequires: libprotobuf-devel
BuildRequires: libtinyxml2-devel
BuildRequires: libgz-common-devel
BuildRequires: libgz-math-devel
BuildRequires: libgz-msgs-devel
BuildRequires: gz-tools
BuildRequires: libyaml-devel
BuildRequires: libzip-devel
BuildRequires: libcurl-devel
BuildRequires: libpsl-devel
BuildRequires: pkgconfig(gnutls)
BuildRequires: pkgconfig(libgsasl)
BuildRequires: pkgconfig(jsoncpp)
BuildRequires: pkgconfig(libnghttp2)
BuildRequires: pkgconfig(libnghttp3)
BuildRequires: pkgconfig(libngtcp2)
BuildRequires: pkgconfig(libidn2)
BuildRequires: pkgconfig(libbrotlidec)
BuildRequires: pkgconfig(libssh2)
BuildRequires: pkgconfig(libssl)
BuildRequires: pkgconfig(libtasn1)
BuildRequires: pkgconfig(libzstd)
BuildRequires: pkgconfig(mit-krb5-gssapi)
BuildRequires: pkgconfig(nettle)
BuildRequires: pkgconfig(p11-kit-1)
BuildRequires: /proc

%description
Gazebo Fuel Tools is composed by a client library and command line tools for
interacting with Gazebo Fuel servers.

%package -n lib%name
Summary: Library of %name
Group: System/Libraries

%description -n lib%name
%summary

%package -n lib%{name}-devel
Summary: Development files for %name
Group: Development/C++

%description -n lib%{name}-devel
%summary

%prep
%setup

%build
%cmake -GNinja -Wno-dev
%ninja_build -C "%_cmake__builddir"

%install
%ninja_install -C "%_cmake__builddir"

%files -n lib%name
%doc AUTHORS README.md
%_libexecdir/ruby/*
%_libdir/lib*.so.*
%_libdir/lib*.so
%_datadir/gz/*.yaml
%_datadir/gz/gz2.completion.d/fuel*.bash_completion.sh

%files -n lib%{name}-devel
%_includedir/gz/fuel_tools*
%_libdir/cmake/gz-fuel_tools*
%_libdir/pkgconfig/*.pc

%changelog
