%def_disable snapshot

%define ver_major 2.2
%define api_ver_major 2
%define api_ver 2.2
%define enc_api_ver 2.2

%def_enable pulse
%def_enable sfml
%def_disable qt6

Name: guvcview
Version: %ver_major.2
Release: alt1

Summary: A GTK UVC video viewer
License: GPL-2.0-or-later
Group: Video
Url: http://%name.sourceforge.net/

Vcs: git://git.code.sf.net/p/guvcview/git-master.git

%if_disabled snapshot
Source: http://download.sourceforge.net/%name/%name-src-%version.tar.bz2
%else
Source: %name-%version.tar
%endif

Requires: lib%name = %EVR

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake gcc-c++
BuildRequires: libSDL2-devel >= 2.0.0
BuildRequires: glibc-kernheaders
BuildRequires: libavutil-devel pkgconfig(libavcodec) >= 58
BuildRequires: libgtk+3-devel libportaudio2-devel
BuildRequires: libv4l-devel libpng-devel libudev-devel libusb-devel
BuildRequires: libgsl-devel
%{?_enable_pulse:BuildRequires: libpulseaudio-devel}
%{?_enable_sfml:BuildRequires: libSFML-devel}
%{?_enable_qt6:BuildRequires: qt6-base-devel qt6-tools}

%description
This project aims at providing a simple GTK interface for capturing and
viewing video from devices supported by the linux UVC driver. The
software is based on luvcview  but uses a GTK interface, allowing for a
more user friendly GUI

%package -n lib%name
Summary: GTK UVC video viewer libraries
Group: System/Libraries

%description -n lib%name
This project aims at providing a simple GTK interface for capturing and
viewing video from devices supported by the linux UVC driver. The
software is based on luvcview  but uses a GTK interface, allowing for a
more user friendly GUI.

This package contains GTK UVC video viewer libraries.

%package -n lib%name-devel
Summary: GTK UVC video viewer development files
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
This package contains files necessary to develop applications that use
%name libraries.

%prep
%setup -n %name%{?_disable_snapshot:-src}-%version

%build
%cmake \
    %{?_enable_sfml:-DUSE_SFML=ON} \
    %{?_enable_qt6:-DUSE_QT6=ON}
%nil
%cmake_build

%install
%cmake_install
mkdir -p %buildroot%_niconsdir
install -p -m644 %buildroot%_pixmapsdir/guvcview.png %buildroot%_niconsdir/guvcview.png

desktop-file-install --dir %buildroot%_desktopdir \
    --add-category=Recorder \
    --add-category=Video \
    %buildroot%_desktopdir/guvcview.desktop

%find_lang --output=%name.lang %name gview_v4l2core

%files -f %name.lang
%_bindir/%name
%_desktopdir/%name.desktop
%_pixmapsdir/%name.png
%_niconsdir/%name.png
%_man1dir/%name.1*
%_datadir/appdata/%name.appdata.xml
%doc AUTHORS ChangeLog README*

%files -n lib%name
%_libdir/libgviewaudio.so.*
%_libdir/libgviewrender.so.*
%_libdir/libgviewv4l2core.so.*
%_libdir/libgviewencoder.so.*

#%files -n lib%name-devel
%exclude %_libdir/*.so

%changelog
