%define ver_major 1.5
%define api_ver 1.0

%def_enable introspection
%def_enable vala
%def_enable check
%def_disable docs

Name: gtk-vnc
Version: %ver_major.0
Release: alt2

Summary: VNC viewer widget
Group: System/Libraries
License: LGPL-2.0-or-later
Url: https://wiki.gnome.org/Projects/gtk-vnc

Vcs: https://gitlab.gnome.org/GNOME/gtk-vnc.git

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

Requires: libgtk3vnc = %EVR

%define glib_ver 2.56
%define gtk_ver 3.22
%define gnutls_ver 3.6.0
%define sasl_ver 2.1.27
%define gmp_ver 6.0.0

BuildRequires(pre): rpm-macros-meson %{?_enable_introspection:rpm-build-gir}
BuildRequires: meson
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libgnutls-devel >= %gnutls_ver
BuildRequires: pkgconfig(gmp) >= %gmp_ver
BuildRequires: libcairo-gobject-devel libsasl2-devel >= %sasl_ver
BuildRequires: libpulseaudio-devel zlib-devel perl-Text-CSV
BuildRequires: %_bindir/pod2man
%{?_enable_vala:BuildRequires: vala-tools}
%{?_enable_introspection:BuildRequires: libgtk+3-gir-devel}
%{?_with_python:BuildRequires: python-module-pygobject-devel}
%{?_enable_docs:BuildRequires: gi-docgen}

%description
gtk-vnc is a project providing client side APIs for the RFB protocol/VNC
remote desktop technology.It provides two core C libraries, libgvnc for
interacting with the core RFB protocol and libgtk-vnc for a GTK display
widget.

This package provides gvnccapture and gvncviewer - utilities that use
gtk-vnc libraries.

%package -n libgvnc
Summary: GVnc library
Group: System/Libraries

%description -n libgvnc
gtk-vnc is a project providing client side APIs for the RFB protocol/VNC
remote desktop technology.

This package contains the GObject-based library to interact with the RFB
protocol.

%package -n libgvnc-devel
Summary: GVnc library
Group: Development/C
Requires: libgvnc = %EVR
%{?_disable_vapi:Obsoletes: libgvnc-vala}
%{?_disable_vapi:Provides: libgvnc-vala = %EVR}

%description -n libgvnc-devel
gtk-vnc is a project providing client side APIs for the RFB protocol/VNC
remote desktop technology.

This package provides development files for the GVnc library.

%package -n libgtk3vnc
Summary: VNC viewer widget library
Group: System/Libraries
Requires: libgvnc = %EVR

%description -n libgtk3vnc
gtk-vnc is a VNC viewer widget for GTK. It is built using
coroutines allowing it to be completely asynchronous while
remaining single threaded.

%package -n libgtk3vnc-devel
Summary: Development package for VNC viewer widget library
Group: Development/C
Requires: libgtk3vnc = %EVR
Requires: libgvnc-devel = %EVR
%{?_disable_vapi:Obsoletes: libgtk3vnc-vala}
%{?_disable_vapi:Provides: libgtk3vnc-vala = %EVR}

%description -n libgtk3vnc-devel
gtk-vnc is a VNC viewer widget for GTK. It is built using
coroutines allowing it to be completely asynchronous while
remaining single threaded.

This package provides development files for the GtkVnc widget library.

%package -n libgvnc-gir
Summary: GObject introspection data for the CVnc library
Group: System/Libraries
Requires: libgvnc = %EVR

%description -n libgvnc-gir
GObject introspection data for the GVnc library

%package -n libgvnc-gir-devel
Summary: GObject introspection devel data for the GVnc library
Group: System/Libraries
BuildArch: noarch
Requires: libgvnc-gir = %EVR

%description -n libgvnc-gir-devel
GObject introspection devel data for the GVnc library

%package -n libgvnc-vala
Summary: Vala bindings for GVnc library
Group: Development/C
BuildArch: noarch
Requires: libgvnc = %EVR

%description -n libgvnc-vala
This package provides Vala language bindings for for the GVnc library.

%package -n libgtk3vnc-gir
Summary: GObject introspection data for the GtkVnc library
Group: System/Libraries
Requires: libgtk3vnc = %EVR
Requires: libgvnc-gir = %EVR

%description -n libgtk3vnc-gir
GObject introspection data for the GtkVnc widget library

%package -n libgtk3vnc-gir-devel
Summary: GObject introspection devel data for the GtkVnc library
Group: System/Libraries
BuildArch: noarch
Requires: libgtk3vnc-gir = %EVR
Requires: libgvnc-gir-devel = %EVR

%description -n libgtk3vnc-gir-devel
GObject introspection devel data for the GtkVnc widget library

%package -n libgtk3vnc-vala
Summary: Vala bindings for GtkVnc library
Group: Development/C
Requires: libgtk3vnc = %EVR

%description -n libgtk3vnc-vala
This package provides Vala language bindings for for the GtkVnc widget
library.

%prep
%setup

%build
%meson \
%ifarch %e2k
    -Dwith-coroutine=gthread \
%endif
    %{subst_enable_meson_feature vala with-vala} \
    %{subst_enable_meson_feature docs gi-docs}
%nil
%meson_build

%install
%meson_install
%find_lang %name

%check
%__meson_test

%files -f %name.lang
%_bindir/*
%_man1dir/*

%files -n libgvnc
%_libdir/libgvnc-%api_ver.so.*
%_libdir/libgvncpulse-%api_ver.so.*

%files -n libgvnc-devel
%_libdir/libgvnc-%api_ver.so
%_libdir/libgvncpulse-%api_ver.so
%_includedir/gvnc-%api_ver/
%_includedir/gvncpulse-%api_ver/
%_pkgconfigdir/gvnc-%api_ver.pc
%_pkgconfigdir/gvncpulse-%api_ver.pc

%if_enabled vala
%{?_enable_vapi:%files -n libgvnc-vala}
%_vapidir/gvnc-%api_ver.vapi
%_vapidir/gvnc-%api_ver.deps
%_vapidir/gvncpulse-%api_ver.vapi
%_vapidir/gvncpulse-%api_ver.deps
%endif

%files -n libgtk3vnc
%_libdir/libgtk-vnc-2.0.so.*

%files -n libgtk3vnc-devel
%_libdir/libgtk-vnc-2.0.so
%_includedir/gtk-vnc-2.0
%_pkgconfigdir/gtk-vnc-2.0.pc

%if_enabled vala
%{?_enable_vapi:%files -n libgtk3vnc-vala}
%_vapidir/gtk-vnc-2.0.deps
%_vapidir/gtk-vnc-2.0.vapi
%endif

%if_enabled introspection
%files -n libgvnc-gir
%_typelibdir/GVnc-%api_ver.typelib
%_typelibdir/GVncPulse-%api_ver.typelib

%files -n libgvnc-gir-devel
%_girdir/GVnc-%api_ver.gir
%_girdir/GVncPulse-%api_ver.gir

%files -n libgtk3vnc-gir
%_typelibdir/GtkVnc-2.0.typelib

%files -n libgtk3vnc-gir-devel
%_girdir/GtkVnc-2.0.gir
%endif

%changelog
