Name: gsasl
# Taken from gsasl/configure.ac: LT_CURRENT - LT_AGE.
# Look for `AC_SUBST(LT_CURRENT, *)`, etc. in the source.
%define soversion 18
%define libnso lib%name%soversion
%define libname lib%name
Version: 2.2.1
Release: alt2

Summary: GNU SASL implementation
Group: System/Libraries
License: GPLv3+
Url: http://www.gnu.org/software/gsasl/
# ftp://ftp.gnu.org/gnu/%name/%name-%version.tar.gz
Source: %name-%version.tar

Requires: %libnso = %version-%release

# Automatically added by buildreq on Thu Dec 08 2011
BuildRequires: gtk-doc libgnutls-devel libidn-devel libkrb5-devel libntlm-devel libreadline-devel
BuildRequires: libgcrypt-devel
BuildRequires: texinfo

%description
GNU SASL is an implementation of the Simple Authentication and
Security Layer framework and a few common SASL mechanisms.

%package -n %libnso
Summary: GNU SASL library
Group: System/Libraries
License: LGPLv2+
# The previous versions of this subpackage had non-SLP-compliant names. Make
# apt push them out on upgrades.
Obsoletes: lib%name < 2.2.1-alt1

%description -n %libnso
GNU SASL is an implementation of the Simple Authentication and
Security Layer framework and a few common SASL mechanisms.

This package contains the %libnso runtime library.

%package -n lib%name-devel
Summary: Files for development of lib%name-based applications
Group: Development/C
Requires: %libnso = %version-%release

%description -n lib%name-devel
This package contains files for development of applications
which will use lib%name.

%prep
%setup
sed -i 's/^AM_CPPFLAGS +=/& \$(GSS_CFLAGS)/' lib/gl/Makefile.*

# Use gnulib largefile module in the library as well.
sed -i '/AC_REQUIRE(\[gl_USE_SYSTEM_EXTENSIONS\])/a AC_REQUIRE([AC_SYS_LARGEFILE])' \
	lib/m4/gnulib-comp.m4

%build
%autoreconf
%configure \
	--disable-static \
	--enable-shared \
	--disable-rpath \
	--disable-silent-rules \
	--with-libgcrypt \
	--with-gssapi-impl=mit \
	--disable-obsolete
%make_build

%install
%makeinstall_std
%find_lang %name
sed -i '/libgsasl\.mo/d' %name.lang
%find_lang %libnso

%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1

%check
%make_build -k check

%files -f %name.lang
%_bindir/*
%_man1dir/*
%doc AUTHORS NEWS README THANKS

%files -n %libnso -f %libnso.lang
%_libdir/lib%name.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*.h
%_pkgconfigdir/*.pc
%_infodir/*
%_man3dir/*

%changelog
