%def_disable snapshot

%define ver_major 0.3
%define api_ver %ver_major

%def_enable soup3
%def_enable lua_factory
%def_enable tracker3

%if 0
# test_lua_theaudiodb failed for
%ifnarch %ix86 armh aarch64 %e2k
%def_enable check
%else
%def_disable check
%endif
%endif

# dbus tests broken since dbus-1.14.4
%def_disable check

Name: grilo-plugins
Version: %ver_major.18
Release: alt1

Summary: Plugins for the Grilo framework
Group: Sound
License: LGPL-2.1-or-later
Url: https://wiki.gnome.org/Projects/Grilo

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define tracker3_ver 2.99.2
%define lua_api_ver 5.4

Requires: grilo-tools >= 0.3.15-alt2
%{?_enable_tracker3:Requires: localsearch}
# chromaprint plugin required
Requires: gst-plugins-bad1.0 >= 1.20.3-alt2
%{?_enable_lua:Requires: lua%lua_api_ver}

BuildRequires(pre): rpm-macros-meson %{?_enable_lua:rpm-build-lua}
BuildRequires: meson gperf
BuildRequires: gtk-doc yelp-tools
BuildRequires: libgio-devel >= 2.68
BuildRequires: libgrilo-devel >= %ver_major.15
BuildRequires: libxml2-devel
BuildRequires: libgupnp-av-devel >= 0.5
BuildRequires: libsqlite3-devel
BuildRequires: libgdata-devel >= 0.17
BuildRequires: libgom-devel >= 0.3.2
%if_disabled soup3
BuildRequires: libsoup-devel >= 2.41.3
BuildRequires: pkgconfig(libdmapsharing-3.0) >= 2.9.12
%else
BuildRequires: libsoup3.0-devel >= 3.0.0
BuildRequires: pkgconfig(libdmapsharing-4.0) >= 3.9.12
%endif
BuildRequires: libgcrypt-devel
BuildRequires: libgmime3.0-devel
%{?_enable_tracker3:BuildRequires: pkgconfig(tracker-sparql-3.0) >= %tracker3_ver localsearch}
BuildRequires: liboauth-devel
BuildRequires: libgnome-online-accounts-devel >= 3.18.0
BuildRequires: libtotem-pl-parser-devel >= 3.4.1
BuildRequires: libjson-glib-devel
BuildRequires: libavahi-gobject-devel libavahi-glib-devel libavahi-devel
BuildRequires: libmediaart2.0-devel
BuildRequires: librest-devel
BuildRequires: libarchive-devel
BuildRequires: gst-plugins-bad1.0-devel
%{?_enable_lua_factory:BuildRequires: liblua%lua_api_ver-devel >= 5.3.0 pkgconfig(rest-1.0)}
%{?_enable_check:BuildRequires: xvfb-run lua%lua_api_ver
BuildRequires: grilo-tools localsearch gst-plugins-bad1.0 upower}

%description
Grilo is a framework that provides access to different sources of
multimedia content, using a pluggable system.
This package contains plugins to get information from theses sources:
- Bookmarks
- Filesystem
- Flickr
- Gravatar
- Jamendo
- Last.fm (for album arts)
- Local metadata (album arts and thumbnails)
- Metadata Store
- Podcasts
- Shoutcast
- Tracker
- UPnP
- Vimeo
- Youtube

%package devel
Summary: Development files for Grilo flaugins
Group: Development/Other
Requires: %name = %EVR

%description devel
Grilo is a framework that provides access to different sources of
multimedia content, using a pluggable system.

This package contains the pkg-config file for Grilo plugins package.

%prep
%setup

%build
%meson \
    %{?_enable_lua_factory:-Denable-lua-factory=yes} \
    %{?_disable_tracker3:-Dtracker3=no}
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %name examples

%check
export LANG=en_US.UTF-8
xvfb-run %__meson_test -t 2


%files -f %name.lang
%dir %_libdir/grilo-%ver_major
%_libdir/grilo-%ver_major/libgrlbookmarks.so
%_libdir/grilo-%ver_major/libgrlchromaprint.so
%_libdir/grilo-%ver_major/libgrldaap.so
%_libdir/grilo-%ver_major/libgrldleyna.so
%_libdir/grilo-%ver_major/libgrldpap.so
%_libdir/grilo-%ver_major/libgrlfilesystem.so
%_libdir/grilo-%ver_major/libgrlflickr.so
%_libdir/grilo-%ver_major/libgrlfreebox.so
%_libdir/grilo-%ver_major/libgrlgravatar.so
%_libdir/grilo-%ver_major/libgrllocalmetadata.so
%{?_enable_lua_factory:%_libdir/grilo-%ver_major/libgrlluafactory.so}
%_libdir/grilo-%ver_major/libgrlmagnatune.so
%_libdir/grilo-%ver_major/libgrlmetadatastore.so
%{?_disable_soup3:%_libdir/grilo-%ver_major/libgrlopensubtitles.so}
%_libdir/grilo-%ver_major/libgrlopticalmedia.so
%_libdir/grilo-%ver_major/libgrlpodcasts.so
%_libdir/grilo-%ver_major/libgrlshoutcast.so
%_libdir/grilo-%ver_major/libgrlthetvdb.so
%_libdir/grilo-%ver_major/libgrltmdb.so
%{?_enable_tracker3:%_libdir/grilo-%ver_major/libgrltracker3.so}
%{?_disable_soup3%_libdir/grilo-%ver_major/libgrlyoutube.so}
%if_enabled lua_factory
%dir %_datadir/%name
%_datadir/%name/grl-lua-factory/
%endif
%doc AUTHORS NEWS README*

%files devel
%_pkgconfigdir/%name-%api_ver.pc


%changelog
