%define _unpackaged_files_terminate_build 1

%def_disable docs

Name: gri
Version: 2.12.23
Release: alt7

Summary: A language for scientific illustration
License: GPLv3+
Group: Development/Tools

Url: http://gri.sourceforge.net

Source: %name-%version.tar
Source1: http://gri.sourceforge.net/refcard.pdf
Source2: http://gri.sourceforge.net/cmdrefcard.pdf
Source3: http://gri.sourceforge.net/gri.pdf

Patch1: %name-%version-debian-texi.patch
Patch2: %name-%version-alt-perl-compat.patch
Patch3: %name-%version-alt-gcc7-compat.patch
Patch4: %name-%version-alt-disable-docs.patch

BuildRequires: gcc-c++ ImageMagick-tools texlive-base-bin info
BuildRequires: ghostscript-classic makeinfo
BuildRequires: perl-Perl4-CoreLibs

%description
Gri is a language for scientific graphics programming.  It is a
command-driven application, as opposed to a click/point application.
It is analogous to latex, and shares the property that extensive power
is the reward for tolerating a modest learning curve.  Gri output is
in industry-standard PostScript, suitable for incorporation in
documents prepared by various text processors.

Gri can make x-y graphs, contour-graphs, and image graphs.  In
addition to high-level capabilities, it has enough low-level
capabilities to allow users to achieve a high degree of customization.
Precise control is extended to all aspects of drawing, including
line-widths, colors, and fonts.  Text includes a subset of the tex
language, so that it is easy to incorporate Greek letters and
mathematical symbols in labels.

The following is a terse yet working Gri program.  If it is stored in
a file called 'example.gri', and executed with the unix command 'gri
example', it will create a postscript file called 'example.ps' with
a linegraph connecting data points in the file called `file.dat'.

   open file.dat        # open a file with columnar data
   read columns x * y   # read first column as x and third as y
   draw curve           # draw line through data (autoscaled axes)

%package doc
Summary: Documentation for Gri
Group: Documentation
BuildArch: noarch

%description doc
Gri is a language for scientific graphics programming.  It is a
command-driven application, as opposed to a click/point application.
It is analogous to latex, and shares the property that extensive power
is the reward for tolerating a modest learning curve.  Gri output is
in industry-standard PostScript, suitable for incorporation in
documents prepared by various text processors.

This package contains documentation for Gri.

%prep
%setup
%patch1 -p1
%patch2 -p2
%patch3 -p2
%if_disabled docs
%patch4 -p2
%endif

%build
%ifarch %e2k
# -std=c++03 by default as of lcc 1.23.20
%add_optflags -std=c++11
%endif
%autoreconf
%configure --enable-linux_redhat
%make_build

%install
%makeinstall_std

%if_enabled docs
mv %buildroot%_docdir/%name-%version %buildroot%_docdir/%name
%else
install -d %buildroot%_docdir/%name
%endif
install -pm644 %SOURCE1 %SOURCE2 %SOURCE3 %buildroot%_docdir/%name

%files
%doc AUTHORS COPYING ChangeLog NEWS README THANKS license.txt copyright.txt
%_bindir/*
%_datadir/%name
%if_enabled docs
%_man1dir/*
%_infodir/*
%endif
%_emacslispdir/*

%files doc
%_docdir/%name

%changelog
