Name: gqrx
Version: 2.17.7
Release: alt1

Summary: Software defined radio receiver powered by GNU Radio and Qt.
License: GPL-3.0
Group: Other
URL: https://github.com/csete/gqrx
VCS: https://github.com/csete/gqrx.git

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires (pre): rpm-macros-cmake
BuildRequires: gcc-c++
BuildRequires: gnuradio-devel
BuildRequires: gr-osmosdr-devel
BuildRequires: libfftw3-devel
BuildRequires: libalsa-devel
BuildRequires: libjack-devel
BuildRequires: liborc-devel
BuildRequires: qt6-base-devel
BuildRequires: qt6-svg-devel
BuildRequires: libpulseaudio-devel
BuildRequires: pkgconfig(libpulse)
BuildRequires: pkgconfig(libpulse-simple)
BuildRequires: pkgconfig(gnuradio-analog)
BuildRequires: pkgconfig(gnuradio-blocks)
BuildRequires: pkgconfig(gnuradio-digital)
BuildRequires: pkgconfig(gnuradio-filter)
BuildRequires: pkgconfig(gnuradio-fft)
BuildRequires: pkgconfig(gnuradio-runtime)
BuildRequires: pkgconfig(gnuradio-osmosdr)
BuildRequires: pkgconfig(portaudio-2.0)
BuildRequires: boost-devel
BuildRequires: desktop-file-utils
BuildRequires: libappstream-glib
BuildRequires: libsndfile-devel
BuildRequires: libnumpy-py3-devel
BuildRequires: libunwind-devel

# https://bugzilla.altlinux.org/47318
Requires: qt6-svg

# uhd not available for %ix86 %arm
# gnuradio not available for ppc64le
ExcludeArch: %ix86 %arm ppc64le

%description
%summary.

%prep
%setup
%autopatch -p1

%build
%cmake
%cmake_build

%install
%cmake_install

%check
#This appears to be borked
appstream-util validate-relax --nonet \
               %buildroot/%_datadir/metainfo/*.appdata.xml

%files
%_bindir/%name
%_datadir/applications/*.desktop
%_datadir/metainfo/*.appdata.xml
%_datadir/icons/hicolor/scalable/apps/%name.svg
%doc COPYING LICENSE-CTK README.md

%changelog
