%define libgnutls_soname 30
%define libgnutlsxx_soname 30
%define libgnutls_openssl_soname 27

# For dlopen()-ed libraries soname check
%define libz_soname 1
%define libbrotlienc_soname 1
%define libbrotlidec_soname 1
%define libzstd_soname 1

Name: gnutls%libgnutls_soname
Version: 3.8.11
Release: alt2

Summary: A TLS protocol implementation
# The libgnutls library is LGPLv2.1+, utilities and remaining libraries are GPLv3+
License: LGPLv2.1+ and GPLv3+
Group: System/Libraries
Url: https://gnutls.org/
# ftp://ftp.gnutls.org/pub/gnutls/gnutls-%version.tar.bz2
Source: gnutls-%version.tar

Patch3: Fix-privkey-verify-broken-test.patch
Patch8: fix-32bit-LTS.patch
Patch10: tests-Don-t-use-lscpu.patch
Patch11: tests-Fix-work-with-ALT-faketime.patch
Patch12: Use-python3.patch
Patch13: Pass-path-to-static-leancrypto-library-as-argument.patch

%def_with leancrypto
%def_enable certcompress

%define libcxx libgnutlsxx%libgnutlsxx_soname
%define libssl libgnutls%{libgnutls_openssl_soname}-openssl
#set_automake_version 1.11

# Automatically added by buildreq on Thu Dec 08 2011
BuildRequires: gcc-c++ gtk-doc libgcrypt-devel libp11-kit-devel libreadline-devel libtasn1-devel makeinfo zlib-devel
BuildRequires: libidn2-devel libunistring-devel
BuildRequires: libnettle-devel >= 3.6-alt1
%{?_with_leancrypto:BuildRequires: libleancrypto-devel-static}
%{?_enable_certcompress:BuildRequires: zlib-devel libbrotli-devel libzstd-devel}

# For tests
%{?!_without_check:%{?!_disable_check:BuildRequires: iproute2}}
%{?!_without_check:%{?!_disable_check:BuildRequires: /proc}}
%{?!_without_check:%{?!_disable_check:BuildRequires: faketime}}
# tests/pkcs11/tls-neg-pkcs11-key.c doesn't work with softhsm-2.1.0:
%{?!_without_check:%{?!_disable_check:BuildRequires: softhsm >= 2.4.0}}
%{?!_without_check:%{?!_disable_check:BuildRequires: openssl}}
%{?!_without_check:%{?!_disable_check:BuildRequires: libssl-devel}}
%{?!_without_check:%{?!_disable_check:BuildRequires: socat}}
%{?!_without_check:%{?!_disable_check:BuildRequires: ppp}}
%{?!_without_check:%{?!_disable_check:BuildRequires: /dev/pts}}
%ifnarch %e2k
# no libseccomp on e2k for now
%{?!_without_check:%{?!_disable_check:BuildRequires: libseccomp-devel}}
%endif

%description
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

%package -n lib%name
Summary: Transport Layer Security library
License: LGPLv2.1+
Group: System/Libraries
Provides: libgnutls = %version
Obsoletes: libgnutls < %version
Obsoletes: libgnutls-new < %version

%description -n lib%name
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains the GnuTLS runtime library.

%package -n libgnutls-devel
Summary: Development files for lib%name
Group: Development/C
Requires: lib%name = %version-%release
Obsoletes: libgnutls-new-devel < %version

%description -n libgnutls-devel
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains headers and other development files required to
build GnuTLS-based software.

%package -n %libcxx
Summary: Transport Layer Security C++ library
Group: System/Libraries
License: GPLv3+
Requires: lib%name = %version-%release
Provides: libgnutlsxx = %version
Obsoletes: libgnutlsxx < %version
Obsoletes: libgnutls-newxx < %version

%description -n %libcxx
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains the GnuTLS C++ runtime library.

%package -n libgnutlsxx-devel
Summary: Development files for libgnutlsxx
Group: Development/C++
Requires: %libcxx = %version-%release
Requires: libgnutls-devel = %version-%release
Obsoletes: libgnutls-newxx-devel < %version

%description -n libgnutlsxx-devel
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains headers and other development files required to
build GnuTLS-based software using C++.

%package -n %libssl
Summary: OpenSSL compatibility layer for the GnuTLS library
Group: System/Libraries
Requires: lib%name = %version-%release
Provides: libgnutls-openssl = %version
Obsoletes: libgnutls-openssl < %version
Obsoletes: libgnutls-new-openssl < %version

%description -n %libssl
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains the GnuTLS runtime OpenSSL compatibility library.

%package -n libgnutls-openssl-devel
Summary: Development files for %libssl
Group: Development/C
Requires: %libssl = %version-%release
Requires: libgnutls-devel = %version-%release
Obsoletes: libgnutls-new-openssl-devel < %version

%description -n libgnutls-openssl-devel
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains headers and other development files required to
build applications using the GnuTLS compatibility OpenSSL library.

%package -n gnutls-utils
Summary: TLS protocol utilities
Group: Security/Networking
Obsoletes: gnutls-utils26 < %version-%release
Obsoletes: gnutls-utils28 < %version-%release

%description -n gnutls-utils
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains command line TLS client and server, and
certificate manipulation tools.

%package devel-doc
Summary: Development documentation for GnuTLS
Group: Development/C
Conflicts: libgnutls-devel < %version
Provides: gnutls-devel-doc = %version
Obsoletes: gnutls-devel-doc < %version
Obsoletes: gnutls-new-devel-doc < %version
BuildArch: noarch

%description devel-doc
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains the GnuTLS API Reference Manual.

%prep
%setup -n gnutls-%version
%patch3 -p2
%patch8 -p1
%patch10 -p1
%patch11 -p2
%patch12 -p1
%patch13 -p2
%ifarch %e2k
# error: expression preceding parentheses of apparent call must have (pointer-to-) function type
sed -i 's/__has_c_attribute (__maybe_unused__)/0/' lib/crau/crau.h
%endif

touch doc/*.texi
rm doc/*.info*
rm aclocal.m4 m4/{libtool,lt*}.m4
# Thanks to USE_POSIX_THREADS_WEAK feature, we have to link
# tests with @LIBMULTITHREAD@ in --no-as-needed mode.
sed -i 's/^\(test_[^ +=]\+\)_LDADD.*@LIBMULTITHREAD@.*/&\n\1_LDFLAGS = -Wl,--no-as-needed/' src/gl/tests/Makefile.*
# Use soname in the names of locale files
sed -i -r 's/^DOMAIN = [^[:blank:]#]+/&%libgnutls_soname/' po/Makevars

%build
# Check soname version of libraries which will be dlopen()'ed to
# ensure that the right soname will be used.
# The point that if soname will be changed then test rebuild will fail.
check_lib_soname() {
	# Upper/lower case for variable value is bash5-ism, but it is usefull
	local so_num="$(sed -r -n "s;^#define[[:blank:]]+${1@U}_LIBRARY_SONAME[[:blank:]]+\"lib${1@L}\.so\.([[:digit:]]+)\"$;\1;p"  config.h)"
	if [ "$so_num" != "$2" ]; then
		echo "lib$1 soname version is wrong: $so_num (expected $2)"
		exit 1
	fi
}

%autoreconf
%def_disable static
%configure \
	--disable-rpath \
	--disable-static \
	--disable-silent-rules \
	--disable-libdane  \
	--without-tpm \
	--with-default-trust-store-file=/usr/share/ca-certificates/ca-bundle.crt \
	--with-included-libtasn1=no \
	--enable-openssl-compatibility \
%if_with leancrypto
	--with-leancrypto=%_libdir/libleancrypto.a \
%else
	--without-leancrypto \
%endif
%if_enabled certcompress
	--with-zlib=dlopen \
	--with-brotli=dlopen \
	--with-zstd=dlopen \
%else
	--without-zlib \
	--without-brotli \
	--without-zstd \
%endif
	--docdir=%_docdir/gnutls-%version/

%if_enabled certcompress
check_lib_soname z %libz_soname
check_lib_soname brotlienc %libbrotlienc_soname
check_lib_soname brotlidec %libbrotlidec_soname
check_lib_soname zstd %libzstd_soname
%endif

make MAKEINFOFLAGS=--no-split

%install
%makeinstall_std
find %buildroot%_infodir/ -name '*.png' -delete -print
%define docdir %_docdir/gnutls-%version
mkdir -p %buildroot%docdir/{examples,reference}
install -p -m644 AUTHORS NEWS README.md THANKS %buildroot%docdir/
install -p -m644 doc/*.{cfg,css,html,png} %buildroot%docdir/
install -pm644 doc/examples/*.[hc]* %buildroot%docdir/examples/
install -pm644 doc/reference/html/* %buildroot%docdir/reference/
ln -s %_licensedir/GPL-2 %buildroot%docdir/COPYING
ln -s %_licensedir/LGPL-2.1 %buildroot%docdir/COPYING.LIB

%find_lang gnutls%libgnutls_soname
%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1

%check
# Workaround for tests: gnutls-serv will be rebuilded for some reason
# when it started, so run it before make check to be rebuilded and therefore
# tests willn't fail due to timeout.
src/gnutls-serv --help >/dev/null 2>&1

make -k check

%files -n lib%name -f gnutls%libgnutls_soname.lang
%dir %docdir
%docdir/[ACNRT]*
%_libdir/libgnutls.so.%libgnutls_soname
%_libdir/libgnutls.so.%libgnutls_soname.*

%files -n %libcxx
%_libdir/libgnutlsxx.so.%libgnutlsxx_soname
%_libdir/libgnutlsxx.so.%libgnutlsxx_soname.*

%files -n %libssl
%_libdir/libgnutls-openssl.so.%libgnutls_openssl_soname
%_libdir/libgnutls-openssl.so.%libgnutls_openssl_soname.*

%files -n libgnutls-devel
%_includedir/gnutls/
%exclude %_includedir/gnutls/gnutlsxx.h
%exclude %_includedir/gnutls/openssl.h
%_libdir/libgnutls.so
%_pkgconfigdir/gnutls.pc

%files -n libgnutlsxx-devel
%dir %_includedir/gnutls/
%_includedir/gnutls/gnutlsxx.h
%_libdir/libgnutlsxx.so


%files -n libgnutls-openssl-devel
%dir %_includedir/gnutls/
%_includedir/gnutls/openssl.h
%_libdir/libgnutls-openssl.so

%files devel-doc
%dir %docdir
%docdir/*.css
%docdir/*.html
%docdir/*.png
%docdir/examples/
%docdir/reference/
%_man3dir/*
%_infodir/*

%files -n gnutls-utils
%_bindir/*
%_man1dir/*
%dir %docdir
%docdir/*.cfg

%changelog
