%def_without objc2
%def_with doc

# With LTO enabled here, gnustep-base fails to build. See also:
# https://github.com/gnustep/libs-base/issues/172
# https://bugzilla.redhat.com/show_bug.cgi?id=1923589
# TODO: consider using -fcommon instead of disabling LTO
%define optflags_lto %nil

Name: gnustep-make
Version: 2.8.0
Release: alt3
# https://github.com/gnustep/tools-make
License: GPL-3.0+
Group: Development/Objective-C
Summary: GNUstep Makefile package
Url: http://www.gnustep.org/

Source: %name-%version.tar
Patch1: %name-alt-path-fix.patch

%if_with objc2
BuildRequires: clang-devel libgnustep-objc2-devel star
%endif
%if_with doc
BuildRequires: texlive-dist texlive-latex-base texi2html
%endif

Requires: gnustep-dirs

%description
This package contains the basic scripts, makefiles and directory
layout needed to run and compile any GNUstep software.
This package was configured using flattened mode using the system
GNUstep filesystem layout.

%package devel
Summary: Files needed to develop applications with gnustep-make
Group: Development/Objective-C
Requires: %name = %version-%release
Requires: gcc-objc

%description devel
The makefile package is a simplistic, powerful and extensible way to
write makefiles for a GNUstep-based project. It allows the user to
write a GNUstep-based project without having to deal with the complex
issues associated with the configuration and installation of the core
GNUstep libraries. It also allows the user to easily create
cross-compiled binaries.

%package doc
Summary: Documentation for %name
Group: Development/Documentation
BuildArch: noarch

%description doc
This package contains development documentation for %name.

%prep
%setup
%patch1 -p1

sed -i "s|@64@|%_libsuff|g" FilesystemLayouts/fhs-system-alt

%build
OBJCFLAGS="%optflags"
export OBJCFLAGS="$OBJCFLAGS -DGNUSTEP -DGNU_RUNTIME"
export CFLAGS="%optflags"
export CXXFLAGS="%optflags"
export SHELLPROG="/bin/bash"
%autoreconf
%configure \
	--libexecdir=%_libdir \
	--enable-flattened \
	--with-layout=fhs-system-alt \
%if_with objc2
	--with-objc-lib-flag=-lobjc2 \
%endif
	--enable-native-objc-exceptions \
	--enable-debug-by-default

%if_with doc
%make_build -C Documentation \
	GNUSTEP_MAKEFILES=$PWD
%endif

%install
sed -i 's|/usr/sbin/lsattr|lsattr|g' config.guess
%makeinstall_std

%if_with doc
%makeinstall_std -C Documentation \
	GNUSTEP_MAKEFILES=$PWD
%endif

sed -i 's|-march=i586||g' $(find %buildroot -type f -not -name config.guess -not -name config.sub)
sed -i 's|-mtune=i586||g' $(find %buildroot -type f)
sed -i 's|-mtune=generic||g' \
	%buildroot%_datadir/GNUstep/Makefiles/config.make

rm -f %buildroot%_datadir/GNUstep/Makefiles/bake_debian_files.sh
if grep -Fle %_target_cpu $(find %buildroot%_datadir/GNUstep -type f -not -name config.guess -not -name config.sub -not -name config.make); then
       echo >&2 %buildroot is dirty
       exit 1
fi

install -d %buildroot/etc/profile.d

cat > %buildroot/etc/profile.d/GNUstep.sh << EOF
#!/bin/sh
. %_datadir/GNUstep/Makefiles/GNUstep.sh

if [ ! -d \$GNUSTEP_USER_ROOT ]; then
        mkdir \$GNUSTEP_USER_ROOT
        chmod +rwx \$GNUSTEP_USER_ROOT
        . %_datadir/GNUstep/Makefiles/GNUstep.sh
fi
EOF

sed -i 's|\-march=[0-9a-z_-]*||g' $(find %buildroot -type f)

gzip ChangeLog

# broken
rm -f %buildroot%_infodir/*

%files
%doc ChangeLog*
%_sysconfdir/GNUstep/
%_bindir/*
%dir %_datadir/GNUstep
%dir %_datadir/GNUstep/Makefiles
%dir %_datadir/GNUstep/Makefiles
%attr(755,root,root) %_datadir/GNUstep/Makefiles/*.csh
%attr(755,root,root) %_datadir/GNUstep/Makefiles/*.sh
%_datadir/GNUstep/Makefiles/tar-exclude-list
%_datadir/GNUstep/Makefiles/config.guess
%_datadir/GNUstep/Makefiles/config.sub
%_datadir/GNUstep/Makefiles/gnustep-make-help
%_man1dir/*
%_man7dir/*

%files devel
%attr(755,root,root) %_sysconfdir/profile.d/*
%_datadir/GNUstep/Makefiles/*.make
%_datadir/GNUstep/Makefiles/*.template
%_datadir/GNUstep/Makefiles/Instance
%_datadir/GNUstep/Makefiles/Master
%_datadir/GNUstep/Makefiles/TestFramework
%attr(755,root,root) %_datadir/GNUstep/Makefiles/install-sh
%attr(755,root,root) %_datadir/GNUstep/Makefiles/mkinstalldirs

%if_with doc
%files doc
%_docdir/GNUstep
%endif

%changelog
