%define _unpackaged_files_terminate_build 1                                                                                                                                                   
%set_verify_elf_method unresolved=strict
%def_without objc2

Name: gnustep-gui
Version: 0.32.0
Release: alt1
Summary: The GNUstep GUI library
License: LGPL-2.1+ and GPL-3.0+
Group: Development/Tools
Url: http://www.gnustep.org/

Packager: Andrey Cherepanov <cas@altlinux.org>

# https://github.com/gnustep/gnustep-gui.git
Source: libs-gui-%version.tar
Patch: gnustep-gui-alt-remove-missing-headers.patch

BuildRequires: gnustep-make-devel gnustep-base-devel
%if_with objc2
BuildRequires: libgnustep-objc2-devel libdispatch-objc2-devel
%endif
BuildRequires: libtiff-devel libjpeg-devel
BuildRequires: libpng-devel libcups-devel libaspell-devel aspell
BuildRequires: libungif-devel libaudiofile-devel libportaudio2-devel
BuildRequires: libX11-devel libicu-devel imake libImageMagick-devel
BuildRequires: ImageMagick-tools libsndfile-devel libao-devel
BuildRequires: flite-devel libicns-devel /proc gnustep-base-doc
BuildRequires: texinfo texi2html texlive-latex-base
BuildRequires: libgmp-devel libgnutls-devel libgcrypt-devel
BuildRequires: libxslt-devel libffi-devel
BuildRequires: libkrb5-devel

Requires: lib%name = %version-%release
Requires: aspell flite

%description
The GNUstep GUI library is a library of graphical user interface classes
written completely in the Objective-C language; the classes are based
upon the OpenStep specification as release by NeXT Software, Inc.  These
classes include graphical objects such as buttons, text fields, popup
lists, browser lists, and windows; there are also many associated
classes for handling events, colors, fonts, pasteboards and images.

%package -n lib%name
Summary: Libraries for %name
Group: System/Libraries
License: LGPL-2.1+ and GPL-3.0+

%description -n lib%name
The GNUstep GUI library is a library of graphical user interface classes
written completely in the Objective-C language; the classes are based
upon the OpenStep specification as release by NeXT Software, Inc.  These
classes include graphical objects such as buttons, text fields, popup
lists, browser lists, and windows; there are also many associated
classes for handling events, colors, fonts, pasteboards and images.

This package contains the libraries for %name.

%package devel
Summary: Header files for the gnustep-gui package
Group: Development/Objective-C
License: LGPL-2.1+ and GPL-3.0+
Requires: gnustep-base-devel
Requires: lib%name = %version-%release
Requires: %name = %version-%release

%description devel
The GNUstep GUI library is a library of graphical user interface classes
written completely in the Objective-C language; the classes are based
upon the OpenStep specification as release by NeXT Software, Inc.  These
classes include graphical objects such as buttons, text fields, popup
lists, browser lists, and windows; there are also many associated
classes for handling events, colors, fonts, pasteboards and images.

This package contains the header files for gnustep-gui.

%package doc
Summary: Documentation for %name
Group: Documentation
BuildArch: noarch
License: GFDL-1.2
Requires: gnustep-base-doc
#Requires: %name = %version-%release

%description doc
The GNUstep GUI library is a library of graphical user interface classes
written completely in the Objective-C language; the classes are based
upon the OpenStep specification as release by NeXT Software, Inc.  These
classes include graphical objects such as buttons, text fields, popup
lists, browser lists, and windows; there are also many associated
classes for handling events, colors, fonts, pasteboards and images.

This package contains the documentation for %name.

%prep
%setup -n libs-gui-%version
%patch -p1

%build
. %_datadir/GNUstep/Makefiles/GNUstep.sh
%autoreconf
%configure \
	--libexecdir=%_libdir \
	--enable-imagemagick \
	--with-x \
	--with-installation-domain=SYSTEM

%make_build \
	messages=yes \
	debug=yes \
	strip=no \
	shared=yes \
	AUXILIARY_CPPFLAGS='-I%_includedir/dispatch'

%make_build -C Documentation \
	messages=yes

%install
. %_datadir/GNUstep/Makefiles/GNUstep.sh
%makeinstall_std GNUSTEP_INSTALLATION_DOMAIN=SYSTEM
%makeinstall_std -C Documentation GNUSTEP_INSTALLATION_DOMAIN=SYSTEM

for i in ChangeLog*; do
	gzip $i
done

# broken info
rm -fR %buildroot%_infodir

%files
%doc ANNOUNCE BUGS ChangeLog* COPYING NEWS README
%_bindir/*
%_libdir/GNUstep
%_man1dir/*

%files -n lib%name
%doc COPYING.LIB
%_libdir/*.so.*

%files devel
%_includedir/*
%_libdir/*.so
%_datadir/GNUstep
%_pkgconfigdir/%name.pc

%files doc
#_infodir/*
%_docdir/GNUstep

%changelog
