%set_verify_elf_method unresolved=strict

Name: gnustep-corebase
Version: 0.2
Release: alt6.gite598349
Summary: Open implementation of CoreFoundation
License: LGPL-2.0+ and GPL-3.0+
Group: Graphical desktop/GNUstep
Url: http://www.gnustep.org/
Packager: Andrey Cherepanov <cas@altlinux.org>

# https://github.com/gnustep/gnustep-corebase.git
Source: %name-%version.tar

ExcludeArch: armh ppc64le

BuildRequires: gnustep-make-devel gnustep-base-devel
BuildRequires: libicu-devel /proc
BuildRequires: doxygen graphviz
BuildRequires: libgmp-devel libgnutls-devel libgcrypt-devel
BuildRequires: libxslt-devel libffi-devel zlib-devel
BuildRequires: libdispatch-devel

%description
The GNUstep CoreBase Library is a library of general-purpose,
non-graphical C objects.  For example, it includes types for strings,
collections, byte streams, typed coders, invocations, notifications,
notification dispatchers, moments in time, network ports, and event
loops.

It provides functionality that aims to implement the non-graphical
portion of Apple's CoreFoundation framework.

%package -n lib%name
Summary: Open implementation of CoreFoundation
Group: System/Libraries

%description -n lib%name
The GNUstep CoreBase Library is a library of general-purpose,
non-graphical C objects.  For example, it includes types for strings,
collections, byte streams, typed coders, invocations, notifications,
notification dispatchers, moments in time, network ports, and event
loops.

It provides functionality that aims to implement the non-graphical
portion of Apple's CoreFoundation framework.

This package contains shared libraries of the GNUstep CoreBase Library.

%package -n lib%name-devel
Summary: Development files of open implementation of CoreFoundation
Group: Development/Objective-C
Provides: %name-devel = %version-%release
Requires: lib%name = %version-%release

%description -n lib%name-devel
The GNUstep CoreBase Library is a library of general-purpose,
non-graphical C objects.  For example, it includes types for strings,
collections, byte streams, typed coders, invocations, notifications,
notification dispatchers, moments in time, network ports, and event
loops.

It provides functionality that aims to implement the non-graphical
portion of Apple's CoreFoundation framework.

This package contains development files of the GNUstep CoreBase Library.

%prep
%setup

%build
. %_datadir/GNUstep/Makefiles/GNUstep.sh

%autoreconf
%configure \
	--libexecdir=%_libdir \
	--with-zoneinfo-dir=%_datadir/zoneinfo \
	--with-installation-domain=SYSTEM

%make_build \
	messages=yes \
	debug=yes \
	strip=no \
	shared=yes
 
%install
. %_datadir/GNUstep/Makefiles/GNUstep.sh

%makeinstall_std GNUSTEP_INSTALLATION_DOMAIN=SYSTEM

%files -n lib%name
%doc ANNOUNCE ChangeLog README
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so

%changelog
