%define lang en

Name: gnupg-manual-%lang
Version: 20070416
Release: alt1
Serial: 1

Summary: The GNU Privacy Handbook
Summary(ru_RU.UTF-8): Руководство GNU по обеспечению конфиденциальности
License: FDLv1.1+
Group: Books/Howtos
Url: http://www.gnupg.org/documentation/guides.en.html

Source: gph-svn%version.tar

Provides: gnupg-manual = %version %name = %version
Obsoletes: gnupg-manual <= 1.2.0

BuildArch: noarch

Packager: Sergey Kurakin <kurakin@altlinux.org>

# Automatically added by buildreq on Wed Sep 15 2010 (-bi)
BuildRequires: docbook-utils

%description
The GNU Privacy Handbook
GnuPG is GNU's tool for secure communication and data storage.
It can be used to encrypt data and to create digital signatures.
It includes an advanced key management facility and is compliant
with the proposed OpenPGP Internet standard as described in RFC2440.

%description -l ru_RU.UTF-8
Руководство GNU по обеспечению конфиденциальности
GnuPG - инструмент обеспечения безопасности коммуникаций и хранения
данных. Используется для шифрования данных и создания цифровых
подписей. Включает средства управления ключами и соответствует
предложенному OpenPGP стандарту Internet (RFC2440).

%prep
%setup -c -n %name-%version

%build
cd %lang
#if [ -f signatures.fig -a ! -f signatures.jpg ]; then
#    fig2dev -L jpeg -m 0.7 signatures.fig signatures.jpg
#fi

# remove text of the GNU FDL from the document
# GNU FDL v. 1.1 is a part of common-licenses package
#sed -i "s/&license//g" manual.sgml

# build
db2html -e no-valid manual.sgml
mv signatures.jpg manual/signatures.jpg

# rename index file as index.html with links correction
mv manual/book1.html manual/index.html
sed -i 's/HREF="book1.html"/HREF="index.html"/g' manual/*.html

%install
mkdir -p %buildroot%_defaultdocdir/%name
cp -Rf %lang/manual/* %buildroot%_defaultdocdir/%name

%files
%_defaultdocdir/*

%changelog
