Name: gnupg
Version: 1.4.23
Release: alt5

Summary: The GNU Privacy Guard
# see e.e. keyserver subdirectory
License: GPLv3+ with exceptions
Group: File tools
Url: http://www.gnupg.org/

# ftp://ftp.gnupg.org/GnuPG/gnupg/gnupg-%version.tar.bz2
Source: gnupg-%version.tar

Source1: pgp2gnupg.html
Source2: gpg-convert-from-106.1
Source3: gpgsplit.1
Source4: lspgpot.1
Source5: ftp://ftp.gnupg.org/gcrypt/gnupg/GnuPG-FAQ.new.txt

Patch: gnupg-%version-%release.patch

Provides: gpg, openpgp

# due to gpg-zip(1) manpage (ALT#21411)
Conflicts: gnupg2-common < 2.0.13

%define _sysconfdir /etc/%name
%define _libexecdir %_prefix/libexec
%def_enable ldap

BuildPreReq: bzlib-devel libreadline-devel makeinfo zlib-devel
BuildRequires: libsha1detectcoll-devel
%if_enabled ldap
BuildPreReq: libldap-devel
%endif #enabled ldap

%package ldap
Group: File tools
Summary: The LDAP keyserver interface for the GNU Privacy Guard
Requires: %name = %version-%release

%description
GnuPG (GNU Privacy Guard) is a GNU utility for encrypting data
and creating digital signatures.  GnuPG has advanced key management
capabilities and is compliant with the proposed OpenPGP Internet standard
described in RFC2440.  Because GnuPG doesn't use any patented algorithms,
it is not compatible with some versions of PGP 2 which use only the
patented IDEA algorithm.  See http://www.gnupg.org/why-not-idea.html
for information on using IDEA if the patent does not apply to you and
you need to be compatible with these versions of PGP 2.

%description ldap
This package contains the LDAP keyserver interface
for the GNU Privacy Guard.

%prep
%setup
%patch -p1
rm po/ru.gmo
install -pm644 %_sourcedir/GnuPG-FAQ.new.txt doc/FAQ

iconv -f iso-8859-15 -t utf8 < THANKS > THANKS.utf8
mv THANKS.utf8 THANKS

sed -i s/pkgdata/sysconf/ g10/Makefile.am
install -p -m644 %_sourcedir/pgp2gnupg.html doc/
%__subst -p 's,/usr\[/local\]/share/gnupg,%_sysconfdir,g' doc/gpg.*
find -type f -print0 |
	xargs -r0 grep -FlZ xloadimage -- |
	xargs -r0 %__subst -p s/xloadimage/xli/g --
find -type f -print0 |
	xargs -r0 grep -FlZ docbook-to-man -- |
	xargs -r0 %__subst -p s/docbook-to-man/docbook2man/g --
xz -9k NEWS doc/{DETAILS,FAQ,samplekeys.asc}

%build
rm aclocal.m4
%add_optflags -fno-strict-aliasing
export CC='%__cc -std=gnu99'
autoreconf -fisv
rm -r zlib bzlib
%__subst -p 's/^mkinstalldirs = .*/mkinstalldirs = \$(SHELL) \$(MKINSTALLDIRS)/' po/Makefile.in.in
%configure \
	--enable-static-rnd=linux \
	--with-mailprog=%_sbindir/sendmail \
	--program-prefix= \
	--enable-noexecstack \
	%{subst_enable ldap} \
	#
make -C po update-gmo
%make_build

%check
%make_build -k check
# Simplest non-colliding KAT. sha1 is now alias for sha1dc, so both return the
# same sha1 value.
printf abc | g10/gpg --print-md sha1   | grep -x 'A999 3E36 4706 816A BA3E  2571 7850 C26C 9CD0 D89D'
printf abc | g10/gpg --print-md sha1dc | grep -x 'A999 3E36 4706 816A BA3E  2571 7850 C26C 9CD0 D89D'

%install
%makeinstall_std
install -pm755 tools/lspgpot %buildroot%_bindir/lspgpot
install -pm755 tools/convert-from-106 %buildroot%_bindir/gpg-convert-from-106
install -pm644 %_sourcedir/{gpg-convert-from-106,gpgsplit,lspgpot}.1 \
	%buildroot%_man1dir/

# Remove from %_datadir/%name what we install into %_docdir/%name-%version
rm -rv %buildroot%_datadir/%name

%find_lang %name

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%pre
/usr/sbin/groupadd -r -f _gnupg

%files -f %name.lang
%attr(2711,root,_gnupg) %_bindir/gpg
%_bindir/gpg?*
%_bindir/lspgpot
%_libexecdir/%name
%if_enabled ldap
%exclude %_libexecdir/%name/*ldap*
%endif #enabled ldap
%config(noreplace) %_sysconfdir/
%_mandir/man?/*
%_infodir/*.info*
%doc AUTHORS BUGS NEWS.xz PROJECTS README THANKS TODO
%doc doc/{HACKING,OpenPGP,highlights-1.4.txt,*.xz,*.html}
%doc tools/ring-a-party

%if_enabled ldap
%files ldap
%dir %_libexecdir/%name
%_libexecdir/%name/*ldap*
%endif #enabled ldap

%changelog
