%def_with postgresql
Name: gnunet
Version: 0.25.2
Release: alt1

Summary: Peer-to-peer framework

License: GPLv3+
Group: Communications
Url: http://gnunet.org/
Packager: ALT QA Team <qa@packages.altlinux.org>

Source: http://ftpmirror.gnu.org/gnunet/%name-%version.tar

Source3: gnunetd.sysusers

Patch2: gnunet-0.11.0-alt-mysql8-transition.patch

BuildRequires(pre): rpm-macros-meson

# FIXME: where is rpm-build-meson??
BuildRequires: meson

BuildRequires: gcc-c++ libmysqlclient21-devel libextractor-devel libgcrypt-devel libglade-devel libncursesw-devel libsqlite3-devel zlib-devel
#BuildRequires: %_bindir/git %_bindir/svnversion libICE-devel libSM-devel
BuildRequires: glib2-devel libglpk-devel libgnutls-devel libltdl7-devel libmicrohttpd-devel libunistring-devel pkgconfig(libgtop-2.0)
BuildRequires: libpulseaudio-devel libopus-devel libogg-devel libcurl-devel libsodium-devel libgmp-devel
BuildRequires: libidn2-devel libjansson-devel libzbar-devel
%if_with postgresql
BuildRequires: libpq-devel
%endif

%description
GNUnet is a peer-to-peer framework with focus on providing security. All
peer-to-peer messages in the network are confidential and authenticated.
The framework provides a transport abstraction layer and can currently
encapsulate the network traffic in UDP (IPv4 and IPv6), TCP (IPv4 and IPv6),
HTTP, or SMTP messages. GNUnet supports accounting to provide contributing
nodes with better service. The primary service build on top of the framework
is anonymous file sharing.

%package -n lib%name
Summary: Libraries needed for %name
Group: System/Libraries

%description -n lib%name
GNUnet is a peer-to-peer framework with focus on providing security. All
peer-to-peer messages in the network are confidential and authenticated.
The framework provides a transport abstraction layer and can currently
encapsulate the network traffic in UDP (IPv4 and IPv6), TCP (IPv4 and IPv6),
HTTP, or SMTP messages. GNUnet supports accounting to provide contributing
nodes with better service. The primary service build on top of the framework
is anonymous file sharing.

%package -n lib%name-devel
Summary: Headers for developing programs that will use %name
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package contains the headers that programmers will need to develop
applications which will use %name.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install

%find_lang %name

#install -D -m0644 contrib/services/systemd/gnunet.service %buildroot%_unitdir/gnunetd.service
install -D -m0644 %SOURCE3 %buildroot%_sysusersdir/gnunetd.conf

rm -rv %buildroot%_infodir/
# unpackaged files found
#rm -v %buildroot%_docdir/gnunet/COPYING %buildroot%_docdir/gnunet/README
#rm -rv %buildroot%_datadir/gnunet/services/

%files -f %name.lang
%doc AUTHORS ChangeLog NEWS README
%doc %_man1dir/gnunet*.1*
%doc %_man5dir/gnunet*.5*
%doc %_docdir/%name/
%_bindir/gnunet-arm
#_bindir/gnunet-ats
%_bindir/gnunet-abd
%_bindir/gnunet-auto-share
%_bindir/gnunet-bugreport
%_bindir/gnunet-cadet
%_bindir/gnunet-config
%_bindir/gnunet-core
%_bindir/gnunet-directory
%_bindir/gnunet-dht-get
%_bindir/gnunet-dht-monitor
%_bindir/gnunet-dht-put
%_bindir/gnunet-download
#_bindir/gnunet-download-manager.scm
#%_bindir/gnunet-ecc
%_bindir/gnunet-fs
%_bindir/gnunet-gns
#_bindir/gnunet-gns-import.sh
%_bindir/gnunet-gns-proxy-setup-ca
#_bindir/gnunet-mesh
%_bindir/gnunet-namestore
%_bindir/gnunet-nat
%_bindir/gnunet-nat-auto
%_bindir/gnunet-nat-server
#_bindir/gnunet-peerinfo
#_bindir/gnunet-peerstore
#%_bindir/gnunet-pseudonym
%_bindir/gnunet-publish
%_bindir/gnunet-resolver
%_bindir/gnunet-reclaim
#%_bindir/gnunet-rsa
%_bindir/gnunet-search
%_bindir/gnunet-scalarproduct
%_bindir/gnunet-statistics
#_bindir/gnunet-template
#%_bindir/gnunet-testing
#%_bindir/gnunet-testing-run-service
#_bindir/gnunet-transport
%_bindir/gnunet-transport-certificate-creation
%_bindir/gnunet-unindex
%_bindir/gnunet-uri
%_bindir/gnunet-vpn
#_bindir/gnunet-bcd
%_bindir/gnunet-conversation
%_bindir/gnunet-conversation-test
%_bindir/gnunet-datastore
%_bindir/gnunet-identity
%_bindir/gnunet-namecache
%_bindir/gnunet-nse
%_bindir/gnunet-qr
%_bindir/gnunet-revocation
%_bindir/gnunet-zoneimport
#_bindir/gnunet-set-ibf-profiler
#_bindir/gnunet-set-profiler
%_bindir/gnunet-base32
%_bindir/gnunet-dht-hello
%_bindir/gnunet-did
%_bindir/gnunet-ecc
%_bindir/gnunet-hello
%_bindir/gnunet-messenger
%_bindir/gnunet-namestore-dbtool
%_bindir/gnunet-namestore-zonefile
%_bindir/gnunet-pils
%_bindir/gnunet-rps
%_bindir/gnunet-scrypt
%_bindir/gnunet-testbed
%_bindir/gnunet-testing-netjail-launcher

#_libexecdir/gnunet/libexec/gnunet-helper-audio-playback
#_libexecdir/gnunet/libexec/gnunet-helper-audio-record
#_libexecdir/gnunet/libexec/gnunet-service-conversation

%_datadir/gnunet/
#_unitdir/gnunetd.service
%config %_sysusersdir/gnunetd.conf
%_desktopdir/gnunet-uri.desktop

%files -n lib%name
%_libdir/gnunet/
%_libdir/libgnunetarm.so.*
#_libdir/libgnunetats.so.*
%_libdir/libgnunetabd.so.*
%_libdir/libgnunetcoreunderlaydummy.so.0.0.0
%_libdir/libgnunetmhd.so.*
%_libdir/libgnunetnat.so.*
%_libdir/libgnunetpils.so.*
%_libdir/libgnunetrps.so.*
%_libdir/libgnunettestingcore.so.*
%_libdir/libgnunetblock.so.*
%_libdir/libgnunetblockgroup.so.*
%_libdir/libgnunetcadet.so.*
%_libdir/libgnunetconsensus.so.*
%_libdir/libgnunetcore.so.*
%_libdir/libgnunetdatacache.so.*
%_libdir/libgnunetdatastore.so.*
%_libdir/libgnunetdht.so.*
%_libdir/libgnunetdns.so.*
#%_libdir/libgnunetdnsparser.so.*
#%_libdir/libgnunetdnsstub.so.*
#_libdir/libgnunetfragmentation.so.*
%_libdir/libgnunetfs.so.*
%_libdir/libgnunetgns.so.*
#%_libdir/libgnunetgns_common.so.*
%_libdir/libgnunethello.so.*
#%_libdir/libgnunetlockmanager.so.*
#_libdir/libgnunetmesh.so.*
#%_libdir/libgnunetmy.so.*
#%_libdir/libgnunetmysql.so.*
%_libdir/libgnunetnamestore.so.*
%_libdir/libgnunetnatauto.so.*
%_libdir/libgnunetnatnew.so.*
%_libdir/libgnunetnse.so.*
#_libdir/libgnunetnt.so.*
#_libdir/libgnunetpeerinfo.so.*
%_libdir/libgnunetpeerstore.so.*
%if_with pgsql
%_libdir/libgnunetpq.so.*
%endif
%_libdir/libgnunetreclaim.so.*
#_libdir/libgnunetreclaimattribute.so.*
%_libdir/libgnunetrest.so.*
%_libdir/libgnunetregex.so.*
%_libdir/libgnunetregexblock.so.*
%_libdir/libgnunetstatistics.so.*
#_libdir/libgnunetatsapplication.so.*
#_libdir/libgnunetatstransport.so.*
%_libdir/libgnunetscalarproduct.so.*
%_libdir/libgnunetsecretsharing.so.*
%_libdir/libgnunetsq.so.*
%_libdir/libgnunetcurl.so.*
%_libdir/libgnunetjson.so.*
#%_libdir/libgnunetjsonapi.so.*
#%_libdir/libgnunetjsonapiutils.so.*
#%_libdir/libgnunetstream.so.*
#%_libdir/libgnunettestbed.so.*
#%_libdir/libgnunettesting.so.*
#_libdir/libgnunettransport.so.*
%_libdir/libgnunettransportcore.so.*
%_libdir/libgnunettransportmonitor.so.*
%_libdir/libgnunettransportapplication.so.*
%_libdir/libgnunettransportcommunicator.so.*
#%_libdir/libgnunettun.so.*
%_libdir/libgnunetutil.so.*
%_libdir/libgnunetvpn.so.*
%_libdir/libgnunetconversation.so.*
#_libdir/libgnunetfriends.so.*
%_libdir/libgnunetgnsrecord.so.*
%_libdir/libgnunetidentity.so.*
%_libdir/libgnunetmicrophone.so.*
%_libdir/libgnunetnamecache.so.*
%_libdir/libgnunetrevocation.so.*
%_libdir/libgnunetset.so.*
%_libdir/libgnunetspeaker.so.*
%_libdir/libgnunetdid.so.*
%_libdir/libgnunetgnsrecordjson.so.*
%_libdir/libgnunetmessenger.so.*
%_libdir/libgnunetpq.so.*
%_libdir/libgnunetseti.so.*
%_libdir/libgnunetsetu.so.*
%_libdir/libgnunettestbed.so.*
%_libdir/libgnunettesting.so.*
%_libdir/libgnunettestingarm.so.*
%_libdir/libgnunettestingtestbed.so.*
%_libdir/libgnunettestingtransport.so.*
%_libdir/libnss_gns.so.2
%_libdir/libnss_gns4.so.2
%_libdir/libnss_gns6.so.2

%files -n lib%name-devel
%_includedir/gnunet/
%_libdir/*.so
%_pkgconfigdir/*.pc

%changelog
