%define _unpackaged_files_terminate_build 1
%set_verify_elf_method unresolved=relaxed

%def_enable python
%def_with aqbanking

Name: 	 gnucash
Version: 5.13
Release: alt2

Summary: GnuCash is an application to keep track of your finances
Summary(ru_RU.UTF8): Программа учёта финансов GnuCash

License: GPL-2.0+
Group:   Office
Url: 	 http://www.gnucash.org

Packager: Andrey Cherepanov <cas@altlinux.org>

Source:  %name-%version.tar
Source1: gtest.tar
Source2: %name.1
# This source got from https://sourceforge.net/projects/gnucash/files/gnucash%20(stable)/4.6/gnucash-4.6.tar.bz2
Source3: gnc-vcs-info.h
Source4: ChangeLog
Source5: %name-README.RU
Source7: conv_gnucash2.sh
Source8: gnucash.appdata.xml.in
Source9: gnucash.desktop.in

Patch2: %name-alt-fix-rpath.patch

# munmap_chunk(): invalid pointer
ExcludeArch: armh

AutoReq: yes, noperl

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires: gcc-c++
BuildRequires: libgtk+3-devel
BuildRequires: doxygen graphviz guile-devel intltool libglade-devel
BuildRequires: libgwenhywfar-devel libgwenhywfar-gtk3
BuildRequires: libofx-devel libreadline-devel slib-guile
BuildRequires: libdconf-devel
BuildRequires: libdbi-devel
BuildRequires: libdbi-drivers-devel
BuildRequires: libdbi-drivers-dbd-sqlite3
BuildRequires: libdbi-drivers-dbd-mysql
BuildRequires: libdbi-drivers-dbd-pgsql
BuildRequires: swig
BuildRequires: libexpat-devel
BuildRequires: libffi-devel
BuildRequires: libpcre-devel
BuildRequires: libpixman-devel
BuildRequires: libdrm-devel
BuildRequires: libsecret-devel
BuildRequires: xsltproc
BuildRequires: zlib-devel
BuildRequires: libxslt-devel
BuildRequires: boost-locale-devel
BuildRequires: boost-filesystem-devel
BuildRequires: boost-program_options-devel
BuildRequires: boost-asio-devel
%if_with aqbanking
BuildRequires: aqbanking-devel
%endif
BuildRequires: libgmock-devel libgtest-devel
BuildRequires: libwebkit2gtk-devel
%if_enabled python
BuildRequires: python3-devel
%endif
BuildRequires: perl-podlators
BuildRequires: perl-JSON
BuildRequires: perl-Date-Manip
BuildRequires: /proc

Requires: %{name}-program = %EVR
Requires: %{name}-quotes = %EVR
Requires: %{name}-docs
Requires: slib-guile
Requires: dconf

%description
GnuCash is a personal finance manager. A check-book like
register GUI allows you to enter and track bank accounts,
stocks, income and even currency trades. The interface is
designed to be simple and easy to use, but is backed with
double-entry accounting principles to ensure balanced books.

%description -l ru_RU.UTF8
GnuCash -- это личный финансовый менеджер. Книга учёта
в виде журнала на экране позволит вам вводить и отслеживать
состояние банковских счетов, ценных бумаг, приход денег и
даже курсы валют. Интерфейс программы разработан простым и
лёгким в использовании, но в то же время применяется
принцип двойной записи для обеспечения сведения баланса.

%package program
Summary: Program of GnuCash
Summary(ru_RU.UTF8): GnuCash (программа)
Group: Office
Requires: lib%name = %EVR

%description program
Executable files of GnuCash without documentation.

%description program -l ru_RU.UTF8
Исполняемые файлы GnuCash без документации.

%package -n lib%name-devel
Group: Development/C
Summary: Libraries needed to develop for gnucash
Summary(ru_RU.UTF8): Библиотеки, требуемые для разработки с gnucash
Requires: lib%name = %version
Obsoletes: %name-devel

%description -n lib%name-devel
Libraries needed to develop for gnucash.
%description -n lib%name-devel -l ru_RU.UTF8
Библиотеки, требуемые для разработки с gnucash.

%package -n lib%name
Summary: Libraries for gnucash (sql backends too).
Group: System/Libraries

%add_findprov_lib_path %_libdir/%name

%description -n lib%name
This package provides libraries to use gnucash.

%description -n lib%name -l ru_RU.UTF8
Пакет предоставляет библиотеки, используемые gnucash.

%package quotes
Summary: Allow GnuCash to fetch quotes
Group: Office
Requires: %name
Requires: perl-Date-Manip perl-Finance-Quote

%description quotes
Virtual package that install needed perl modules for quote's online
fetch and update.

%prep
%setup
%patch2 -p1
tar xf %SOURCE1
mv googletest-release-1.11.0 gtest
cp %SOURCE2 doc
cp %SOURCE3 libgnucash/core-utils
cp %SOURCE4 .
cp %SOURCE8 gnucash/gnome
cp %SOURCE9 gnucash/gnome
%ifarch %e2k
sed -i 's/-Werror/-Wno-error/g' CMakeLists.txt
%endif

%build
%cmake -GNinja \
%if_without aqbanking
       -DWITH_AQBANKING=OFF \
%endif
       -DCMAKE_C_FLAGS="-DGLIB_DISABLE_DEPRECATION_WARNINGS" \
       -DCMAKE_CXX_FLAGS="-DGLIB_DISABLE_DEPRECATION_WARNINGS" \
       -DCMAKE_SKIP_RPATH=OFF \
       -DCMAKE_SKIP_INSTALL_RPATH=OFF \
       -DCMAKE_INSTALL_RPATH:DIR=%_libdir/%name \
       -DGENERATE_SWIG_WRAPPERS=ON \
       -DGMOCK_ROOT=%_builddir/%name-%version/gtest \
       -DGTEST_ROOT=%_builddir/%name-%version/gtest
%ninja_build -C "%_cmake__builddir"

%install
%ninja_install -C "%_cmake__builddir"
mv %buildroot%_libdir/lib* %buildroot%_libdir/gnucash/

rm -rf %buildroot%_bindir/gnucash-valgrind \
       %buildroot%_libexecdir/%name/src/

%find_lang %name --with-gnome

install -m755 %SOURCE7 %buildroot%_bindir/conv_gnucash2.sh

tar cfJ ChangeLog.tar.xz ChangeLog{,.????}

rm -f %buildroot%_datadir/gnucash/gnome \
      %buildroot%_bindir/gnc-test-env \
      %buildroot%_bindir/gnc-fq-update \
      %buildroot%_datadir/glib-2.0/schemas/gschemas.compiled

rm -rf %buildroot%_datadir/guile/site/*/tests \
       %buildroot%_libdir/guile/*/site-ccache/tests

%files

%files -n lib%name-devel
%_includedir/%name/

%files -n lib%name
%dir %_libdir/%name/
%_libdir/%name/lib*.so

%files program -f %name.lang
%doc AUTHORS ChangeLog.tar.xz HACKING NEWS README*
%doc doc/README.* doc/examples
%doc %_defaultdocdir/%name/
%_bindir/*
%config %_sysconfdir/%name
%_datadir/guile/site/*/%name
%_libdir/guile/*/site-ccache/%name
%_desktopdir/%name.desktop
%_datadir/%name/
%doc %_man1dir/*
%_iconsdir/hicolor/*/apps/*.png
%_iconsdir/hicolor/scalable/apps/*.svg
%_datadir/metainfo/%name.appdata.xml
%_datadir/glib-2.0/schemas/org.%name.*.xml

%files quotes

%changelog
