%set_verify_info_method relaxed
#set_verify_elf_method textrel=relaxed
%define sover 15

Name: gnuastro
Version: 0.24
Release: alt2
Summary: GNU Astronomy Utilities
License: GPLv3+
Packager: Ilya Mashkin <oddity@altlinux.ru>
Group: Sciences/Other
Url: https://www.gnu.org/software/gnuastro/
Source: https://ftp.gnu.org/pub/gnu/gnuastro/%name-%version.tar.gz
Source2: https://ftp.gnu.org/pub/gnu/gnuastro/%name-%version.tar.gz.sig
Source3: https://akhlaghi.org/public-pgp-key.txt#/%name.keyring
BuildRequires: libtool libgs-devel ghostscript-utils ghostscript
BuildRequires: pkgconfig
BuildRequires: pkgconfig(cfitsio)
BuildRequires: pkgconfig(gsl)
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(libgit2)
BuildRequires: pkgconfig(libjpeg)
BuildRequires: pkgconfig(libtiff-4)
BuildRequires: pkgconfig(wcslib)
Requires: %name-doc curl ghostscript >= 9.10

%description
The GNU Astronomy Utilities (Gnuastro) contains various programs and
library functions for the manipulation and analysis of astronomical
data.

%package -n libgnuastro%sover
Summary: Libraries for the GNU Astronomy Utilities
Group: Sciences/Other
%description -n libgnuastro%sover
Libraries for the manipulation and analysis of astronomical data,
part of the GNU Astronomy Utilities (Gnuastro).

%package devel
Summary: Development files for gnuastro
Requires: libgnuastro%sover = %version
Group: Sciences/Other
%description devel
Development files required for development with GNU Astronomy
Utilities (Gnuastro).

%package doc
Summary: Documentation for the GNU Astromomy Utilities
BuildArch: noarch
Group: Sciences/Other
%description doc
Additional documentation for the GNU Astromomy Utilities.

%package bash-completion
Summary: Bash completion for %name
Group: Shells
Requires: bash-completion %name
BuildArch: noarch

%description bash-completion
Bash command line completion support for %name

%prep
%setup

%build
%autoreconf 
%configure \
	--docdir=%_docdir/%name \
	--disable-static \
	--disable-rpath \
	CPPFLAGS="$(pkg-config cfitsio --cflags)"
%make_build

%install
%makeinstall_std
#find %buildroot -type f -name "*.la" -delete -print
mkdir -p %buildroot/%_datadir/bash-completion/completions
mv -v %buildroot/%_datadir/%name/completion.bash %buildroot/%_datadir/bash-completion/completions/%name

%check

%make_build check


%files
%doc ChangeLog README NEWS THANKS AUTHORS
%dir %_sysconfdir/%name
%config %_sysconfdir/%name/*.conf
%_bindir/*
%_datadir/gnuastro
%_man1dir/*

%files -n libgnuastro%sover
%_libdir/libgnuastro.so.*

%files devel
%_includedir/gnuastro
%_libdir/libgnuastro.so
%_libdir/pkgconfig/*.pc

%files doc
%_infodir/gnuastro.info*.xz
%_infodir/gnuastro-figures

%files bash-completion
%_datadir/bash-completion/completions/%name

%changelog
