%def_disable snapshot

%define rdn_name org.gnome.Gnote
%define _rdn_name org.gnome.gnote
%define ver_major 49
%define api_ver %ver_major
%define beta %nil
%define _libexecdir %_prefix/libexec
%def_without x11_support
%def_disable check

Name: gnote
Version: %ver_major.0
Release: alt1%beta

Summary: Note-taking application
Group: Graphical desktop/GNOME
License: GPL-3.0-or-later
Url: https://wiki.gnome.org/Apps/Gnote

Vcs: https://gitlab.gnome.org/GNOME/gnote.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

%define glibmm_ver 2.74
%define gtkmm_ver 4.10
%define libsecret_ver 0.8
%define gspell_ver 1.6

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson gcc-c++
BuildRequires: yelp-tools
BuildRequires: pkgconfig(glibmm-2.68)  >= %glibmm_ver
BuildRequires: pkgconfig(gtkmm-4.0) >= %gtkmm_ver
BuildRequires: pkgconfig(libadwaita-1)
BuildRequires: pkgconfig(libxml-2.0) pkgconfig(libxslt)
BuildRequires: pkgconfig(libsecret-1) >= %libsecret_ver
BuildRequires: pkgconfig(uuid)
BuildRequires: pkgconfig(gspell-1)
%{?_enable_check:BuildRequires: libunittest-cpp-devel
BuildRequires: desktop-file-utils /usr/bin/appstremcli}

%description
Gnote is a desktop note-taking application which is simple and easy to use.
It lets you organize your notes intelligently by allowing you to easily link
ideas together with Wiki style interconnects. It is a port of Tomboy to C++
and consumes fewer resources.

%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang %name --with-gnome

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_libdir/lib%name-%api_ver.so.*
%_libdir/%name/
%_man1dir/%name.*
%_desktopdir/%rdn_name.desktop
%_datadir/%name/
%_iconsdir/hicolor/*/apps/%rdn_name.*
%_datadir/dbus-1/services/%rdn_name.service
%_datadir/glib-2.0/schemas/%_rdn_name.gschema.xml
%_datadir/metainfo/%rdn_name.appdata.xml
%_datadir/gnome-shell/search-providers/%rdn_name.search-provider.ini
%doc README* TODO NEWS AUTHORS

%exclude %_libdir/lib%name-%api_ver.so

%changelog
