%def_enable snapshot
%define _name video-trimmer
%define ver_major 25.03
%define rdn_name org.gnome.gitlab.YaLTeR.VideoTrimmer

%def_disable bootstrap

Name: gnome-%_name
Version: %ver_major
Release: alt1

Summary: GNOME Video Trimmer
License: GPL-3.0-or-later
Group: Video
Url: https://gitlab.gnome.org/YaLTeR/video-trimmer

Vcs: https://gitlab.gnome.org/YaLTeR/video-trimmer.git

%if_disabled snapshot
Source: %url/archive/-/v%version/%_name-%version.tar.gz
%else
Source: %_name-%version.tar
%endif
Source1: %_name-%version-cargo.tar

%define gtk_ver 4.16.0
%define adw_ver 1.7

Requires: ffmpeg ffprobe

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson rust-cargo blueprint-compiler
BuildRequires: /usr/bin/appstreamcli desktop-file-utils
BuildRequires: pkgconfig(gtk4) >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: typelib(Adw)

%description
Video Trimmer cuts out a fragment of a video given the start and end
timestamps. The video is never re-encoded, so the process is very fast
and does not reduce the video quality.

%prep
%setup -n %_name-%version %{?_disable_bootstrap:-a1}
%{?_enable_bootstrap:
mkdir .cargo
cargo vendor | sed 's/^directory = ".*"/directory = "vendor"/g' > .cargo/config.toml
tar -cf %_sourcedir/%_name-%version-cargo.tar .cargo/ vendor/}

%build -n %_name-%version
%meson
%meson_build

%install
%meson_install
%find_lang %_name

%check
%__meson_test

%files -f %_name.lang
%_bindir/%_name
%_desktopdir/%rdn_name.desktop
%_datadir/%_name/
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_iconsdir/hicolor/*/apps/%{rdn_name}*.svg
%_datadir/metainfo/%rdn_name.metainfo.xml
%doc README*


%changelog
