%def_disable snapshot
%define _libexecdir %_prefix/libexec
%define ver_major 48
%define beta %nil
%define httpd /usr/sbin/httpd2
%define modules_path %_sysconfdir/httpd2/modules

%def_disable bootstrap

Name: gnome-user-share
Version: %ver_major.2
Release: alt1%beta

Summary: Gnome user file sharing
Group: Graphical desktop/GNOME
License: GPL-2.0-or-later
Url: https://www.gnome.org

Vcs: https://gitlab.gnome.org/GNOME/gnome-user-share.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif
Source1: %name-%version-cargo.tar

%define glib_ver 2.74
%define selinux_ver 2.8

Requires: apache2 >= 2.4.0
Requires: apache2-mod_dnssd >= 0.6

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson rust-cargo clang-devel
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libselinux-devel >= %selinux_ver
BuildRequires: apache2 apache2-mod_dnssd pkgconfig(systemd)

%description
gnome-user-share is a small package that binds together various free
software projects to bring easy to use user-level file sharing to the
masses.

The program is meant to run in the background when the user is logged
in, and when file sharing is enabled a webdav server is started that
shares the $HOME/Public folder. The share is then published to all
computers on the local network using mDNS/rendezvous, so that it shows
up in the Network location in Gnome.

The dav server used is apache, so you need that installed. Avahi or
Howl is used for mDNS support, so you need to have that installed and
mDNSResolver running.

%prep
%setup -n %name-%version%beta %{?_disable_bootstrap:-a1}
%{?_enable_bootstrap:
[ ! -d .cargo ] && mkdir .cargo
cargo vendor | sed 's/^directory = ".*"/directory = "vendor"/g' > .cargo/config.toml
tar -cf %_sourcedir/%name-%version-cargo.tar .cargo/ vendor/}

%build
%meson -Dhttpd=%httpd \
       -Dmodules_path=%modules_path
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%files -f gnome-user-share.lang
%_libexecdir/%name-webdav
%_desktopdir/%name-webdav.desktop
%_datadir/%name/
%_datadir/GConf/gsettings/%name.convert
%_datadir/glib-2.0/schemas/org.gnome.desktop.file-sharing.gschema.xml
%_userunitdir/%name-webdav.service
%doc README* NEWS

%changelog
