%def_disable snapshot
%define _unpackaged_files_terminate_build 1

%define xdg_name org.gnome.Usage
%define ver_major 48

%def_enable check

Name: gnome-usage
Version: %ver_major.0
Release: alt1

Summary: The GNOME system information viewer
License: GPL-3.0-or-later
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Usage

Vcs: https://gitlab.gnome.org/GNOME/gnome-usage.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define gtk_ver 4.14
%define gtop_ver 2.34.0
%define adw_ver 1.6
%define nm_ver 1.44

Requires: localsearch

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson vala-tools yelp-tools
BuildRequires: libgtk4-devel >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: libgtop-devel >= %gtop_ver
BuildRequires: pkgconfig(gee-0.8)
BuildRequires: pkgconfig(json-glib-1.0)
BuildRequires: pkgconfig(tinysparql-3.0)
BuildRequires: pkgconfig(libnm) >= %nm_ver
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils}

%description
Gnome Usage is a graphical tool to view system resources, like memory and
disk space.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install

%find_lang --with-gnome %name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/apps/%{xdg_name}*.svg
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc README* NEWS

%changelog
