%def_disable snapshot
%define _unpackaged_files_terminate_build 1
%define xdg_name org.gnome.SystemMonitor

%define ver_major 49
%define beta %nil
%def_enable systemd
%def_enable check

%define _libexecdir %_prefix/libexec

Name: gnome-system-monitor
Version: %ver_major.1
Release: alt1%beta

Summary: Simple process monitor
License: LGPL-2.0-or-later
Group: Monitoring
Url: https://apps.gnome.org/SystemMonitor

Vcs: https://gitlab.gnome.org/GNOME/gnome-system-monitor.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define glib_ver 2.68.0
%define gtk_ver 4.19
%define glibmm_ver 2.68
%define gtkmm_ver 4.19.1
%define libgtop_ver 2.38.0
%define rsvg_ver 2.35
%define adw_ver 1.6

Requires: polkit

BuildRequires(pre): rpm-macros-meson rpm-build-gnome
BuildRequires: meson gcc-c++
BuildRequires: yelp-tools desktop-file-utils
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: pkgconfig(glibmm-2.68) >= %glibmm_ver
BuildRequires: libgtk4-devel >= %gtk_ver
BuildRequires: pkgconfig(gtkmm-4.0) >= %gtkmm_ver
BuildRequires: libgtop-devel >= %libgtop_ver
BuildRequires: librsvg-devel >= %rsvg_ver
BuildRequires: libpolkit-devel
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: pkgconfig(catch2-with-main)
%{?_enable_systemd:BuildRequires: pkgconfig(systemd)}
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils uncrustify}

%description
Gnome-system-monitor is a simple process and system monitor.

%prep
%setup -n %name-%version%beta

%build
%meson \
    %{subst_enable_meson_bool systemd systemd} \
    %{subst_enable_meson_bool wnck wnck}
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%check
%__meson_test

%files -f %name.lang
%_bindir/*
%dir %_libexecdir/%name
%_libexecdir/%name/gsm-kill
%_libexecdir/%name/gsm-renice
%_libexecdir/%name/gsm-taskset
%_desktopdir/*
%_datadir/polkit-1/actions/org.gnome.%name.policy
%config %_datadir/glib-2.0/schemas/org.gnome.%name.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.%name.enums.xml
%_iconsdir/hicolor/*/apps/*
%_datadir/metainfo/%xdg_name.metainfo.xml


%changelog
