%def_disable snapshot

%define ver_major 49
%define beta %nil
%define plugins_ver 23
%define _libexecdir %_prefix/libexec
%define xdg_name org.gnome.Software

%def_enable gudev
%def_enable polkit
%ifarch armh mipsel %e2k
%def_disable fwupd
%else
%def_enable fwupd
%endif
%def_enable flatpak
%ifarch %e2k
%def_disable snap
%else
%def_enable snap
%endif

%def_disable limba
%def_enable packagekit
%def_enable webapps
%def_enable odrs
# disabled by default
%def_disable dkms
# dropped since 3.27.90
%def_disable rpm
%def_disable rpm_ostree
%def_disable external_appstream
%def_enable malcontent
%ifarch %e2k
%def_disable sysprof
%else
%def_enable sysprof
%endif
%def_enable tests
# no /etc/mashine-id in hasher
%def_disable check

Name: gnome-software
Version: %ver_major.2
Release: alt1%beta

Summary: Software manager for GNOME
License: GPL-2.0-or-later
Group: Graphical desktop/GNOME
Url: https://apps.gnome.org/Software

Vcs: https://gitlab.gnome.org/GNOME/gnome-software.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif
# https://bugzilla.altlinux.org/55271
Patch10: %name-48.3-alt-white-list.patch

%define glib_ver 2.76
%define gtk4_ver 4.13.4
%define adw_ver 1.6
%define appstream_ver 0.14
%define json_glib_ver 1.6.0
%define soup_ver 2.52
%define soup3_ver 3.0
%define packagekit_ver 1.2.5
%define gsds_ver 3.18
%define fwupd_ver 1.6.2
%define flatpak_ver 1.9.1
%define snapd_ver 1.6.2
%define ostree_ver 2019.3
%define xmlb_ver 0.3.4
%define malcontent_ver 0.11
%define applist_ver 3.0

Requires: gnome-app-list >= %applist_ver

%{?_enable_packagekit:Requires: appstream-data}
%{?_enable_malcontent:Requires: malcontent} >= %malcontent_ver

BuildRequires(pre): rpm-macros-meson rpm-build-xdg rpm-macros-systemd
BuildRequires: meson libgio-devel >= %glib_ver
BuildRequires: libgtk4-devel >= %gtk4_ver pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: pkgconfig(appstream) >= %appstream_ver
BuildRequires: libjson-glib-devel >= %json_glib_ver
BuildRequires: libsoup3.0-devel >= %soup3_ver
BuildRequires: yelp-tools gtk-doc xsltproc docbook-style-xsl desktop-file-utils
BuildRequires: libsqlite3-devel libsecret-devel liboauth-devel
BuildRequires: gsettings-desktop-schemas-devel >= %gsds_ver
BuildRequires: libgnome-online-accounts-devel
BuildRequires: libxmlb-devel >= %xmlb_ver
BuildRequires: libglib-testing-devel
BuildRequires: pkgconfig(sysprof-capture-4)
%{?_enable sysprof:BuildRequires: pkgconfig(sysprof-capture-4)}
%{?_enable_gudev:BuildRequires: libgudev-devel}
%{?_enable_polkit:BuildRequires: libpolkit-devel}
%{?_enable_fwupd:BuildRequires: fwupd-devel >= %fwupd_ver}
%{?_enable_flatpak:BuildRequires: libflatpak-devel >= %flatpak_ver}
%{?_enable_snap:BuildRequires: pkgconfig(snapd-glib-2) >= %snapd_ver}
%{?_enable_packagekit:BuildRequires: libpackagekit-glib-devel >= %packagekit_ver}
%{?_enable_rpm_ostree:BuildRequires: libostree-devel >= %ostree_ver}
%{?_enable_rpm:BuildRequires: librpm-devel}
%{?_enable_malcontent:BuildRequires: pkgconfig(malcontent-0) >= %malcontent_ver}
%{?_enable_check:BuildRequires: dbus /etc/machine-id python3(dbusmock) gcab epiphany fwupd packagekit flatpak}

%description
GNOME Software is a software center for GNOME.

%package devel
Summary: Development files for GNOME Software
Group: Development/GNOME and GTK+
Requires: %name = %EVR

%description devel
This package contains files necessary to develop plugins for GNOME
Software.

%package plugin-fwupd
Summary: Firmware Upgrade Support for GNOME Software
Group: Graphical desktop/GNOME
Requires: %name = %EVR
Requires: fwupd >= %fwupd_ver

%description plugin-fwupd
This package provides support for firmware upgrades via GNOME Software.

%package devel-doc
Summary: Development documentation for GNOME Software
Group: Development/GNOME and GTK+
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
This package contains documentation necessary to develop plugins for
GNOME Software.


%prep
%setup -n %name-%version%beta
%patch10 -p1

%build
%meson \
    %{subst_enable_meson_bool gudev gudev} \
    %{subst_enable_meson_bool polkit polkit} \
    %{subst_enable_meson_bool fwupd fwupd} \
    %{subst_enable_meson_bool flatpak flatpak} \
    %{subst_enable_meson_bool snap snap} \
    %{subst_enable_meson_bool dkms dkms} \
    %{subst_enable_meson_bool ostree ostree} \
    %{subst_enable_meson_bool rpm_ostree rpm_ostree} \
    %{subst_enable_meson_bool packagekit packagekit} \
    %{subst_enable_meson_bool tests tests} \
    %{subst_enable_meson_bool external_appstream external_appstream} \
    %{subst_enable_meson_feature sysprof sysprof} \
    %{subst_enable_meson_bool malcontent malcontent}
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

ln -sf %name/libgnomesoftware.so.%plugins_ver \
%buildroot%_libdir/libgnomesoftware.so.%plugins_ver

cat << _EOF_ > \
%buildroot%_datadir/glib-2.0/schemas/00_org.gnome.software.gschema.override
[org.gnome.software]
official-repos=['altlinux,']
_EOF_

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_libexecdir/%name-cmd
%_libexecdir/%name-restarter
%{?_enable_external_appstream:%_libexecdir/%name-install-appstream}
%dir %_libdir/%name
%_libdir/%name/libgnomesoftware.so*
#symlink
%_libdir/libgnomesoftware.so.%plugins_ver
%_libdir/%name/plugins-%plugins_ver/
%{?_enable_fwupd:%exclude %_libdir/%name/plugins-%plugins_ver/libgs_plugin_fwupd.so}
%_userunitdir/%name.service
%_desktopdir/%xdg_name.desktop
%_desktopdir/%name-local-file-flatpak.desktop
%{?_enable_snap:%_desktopdir/%name-local-file-snap.desktop}
%_desktopdir/%name-local-file-packagekit.desktop
%_datadir/swcatalog/xml/gnome-pwa-list-foss.xml
%_datadir/swcatalog/xml/gnome-pwa-list-proprietary.xml
%_datadir/dbus-1/services/%xdg_name.service
%{?_enable_packagekit:%_datadir/dbus-1/services/org.freedesktop.PackageKit.service}
%{?_enable_external_appstream:%_datadir/polkit-1/actions/org.gnome.software.external-appstream.policy}
%_datadir/gnome-shell/search-providers/%xdg_name-search-provider.ini
%_iconsdir/hicolor/*/*/*.svg
%_datadir/glib-2.0/schemas/org.gnome.software.gschema.xml
%_datadir/glib-2.0/schemas/00_org.gnome.software.gschema.override
%_datadir/metainfo/%xdg_name.metainfo.xml
%_datadir/bash-completion/completions/%name
%_datadir/metainfo/%xdg_name.Plugin.Epiphany.metainfo.xml
%{?_enable_flatpak:%_datadir/metainfo/%xdg_name.Plugin.Flatpak.metainfo.xml}

%{?_enable_snap:%_datadir/metainfo/%xdg_name.Plugin.Snap.metainfo.xml}
%_man1dir/%name.1.*
%doc AUTHORS README* NEWS

%{?_enable_fwupd:
%files plugin-fwupd
%_libdir/%name/plugins-%plugins_ver/libgs_plugin_fwupd.so
%_desktopdir/%name-local-file-fwupd.desktop
%_datadir/metainfo/%xdg_name.Plugin.Fwupd.metainfo.xml}

%files devel
%_includedir/%name/
%_pkgconfigdir/%name.pc

%files devel-doc
%_datadir/gtk-doc/html/%name/

%changelog
