%def_disable snapshot
%define _libexecdir %_prefix/libexec

%define ver_major 71
%define beta %nil
%define domain gsconnect@andyholmes.github.io
%define xdg_name org.gnome.Shell.Extensions.GSConnect

%def_enable webextension
%def_enable installed_tests
# network required
%def_disable check

Name: gnome-shell-extension-gsconnect
Version: %ver_major
Release: alt1

Summary: GSConnect is a implementation of KDE Connect for GNOME Shell
Group: Graphical desktop/GNOME
License: GPL-2.0-or-later
Url: https://github.com/GSConnect//%name

Vcs: https://github.com/GSConnect/gnome-shell-extension-gsconnect.git

%{?_disable_webextension:BuildArch: noarch}

%if_disabled snapshot
Source: %url/archive/v%version%beta/%name-%version%beta.tar.gz
%else
Source: %name-%version%beta.tar
%endif

Requires: gnome-shell >= 46
Requires: /usr/bin/ffmpeg /usr/bin/fusermount
Requires: /usr/bin/ssh-keygen /usr/bin/ssh-add
Requires: fuse-sshfs /usr/bin/openssl

# Optional
#Requires: typelib(EDataServer)
#Requires: typelib(EBookContacts)

BuildRequires(pre): rpm-macros-meson rpm-build-gir rpm-build-python3
BuildRequires: meson eslint libgio-devel libdbus-devel libgtk4-devel
%{?_enable_check:BuildRequires: xvfb-run %_bindir/gjs typelib(Gdk) = 3.0 typelib(Adw) = 1
BuildRequires: /usr/bin/appstreamcli /usr/bin/eslint}

%add_python3_path %_datadir/gnome-shell/extensions/%domain %_datadir/nautilus-python/extensions
# imports.gi.St.Settings.get()
%add_typelib_req_skiplist typelib(get) typelib(Nemo)

%description
GSConnect is a complete implementation of KDE Connect for
GNOME Shell with Nautilus, Chrome and Firefox integration.

%package tests
Summary: Tests for the GSConnect
Group: Development/Other
Requires: %name = %EVR

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed GSConnect Gnome Shell extension.

%prep
%setup -n %name-%version%beta
sed -i 's|\(^#!/usr/bin/\)env -S \(gjs -m\)|\1\2|' src/gsconnect-preferences \
    src/service/{daemon,nativeMessagingHost}.js installed-tests/minijasmine

%build
%meson \
    %{subst_enable_meson_bool webextension webextension} \
    %{subst_enable_meson_bool installed_tests installed_tests}
%meson_build

%install
%meson_install
%find_lang %xdg_name

%check
xvfb-run %__meson_test

%files -f %xdg_name.lang
%_desktopdir/%xdg_name.desktop
%_desktopdir/%xdg_name.Preferences.desktop
%_datadir/gnome-shell/extensions/%domain/
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/nautilus-python/extensions/nautilus-gsconnect.py
%_datadir/nautilus-python/extensions/__pycache__/*
%_iconsdir/hicolor/*/*/*.svg
%_datadir/metainfo/%xdg_name.metainfo.xml

%if_enabled webextension
%_sysconfdir/chromium/native-messaging-hosts/org.gnome.shell.extensions.gsconnect.json
%_sysconfdir/opt/chrome/native-messaging-hosts/org.gnome.shell.extensions.gsconnect.json
%_libdir/mozilla/native-messaging-hosts/org.gnome.shell.extensions.gsconnect.json
%endif
%doc README.md

%if_enabled installed_tests
%files tests
%_datadir/installed-tests/gsconnect/
%_libexecdir/installed-tests/gsconnect/
%endif

%changelog
