%def_disable snapshot

%define ver_major 49
%define beta %nil
%define xdg_name org.gnome.Music
%define gst_api_ver 1.0
%define soup_api_ver 3.0
%define tracker_api_ver 3.0

%def_enable check

Name: gnome-music
Version: %ver_major.1
Release: alt1%beta

Summary: Music playing application for GNOME3
Group: Sound
License: GPL-2.0-or-later
Url: https://apps.gnome.org/Music

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

BuildArch: noarch

%define tracker_ver 3.0
%define gtk4_ver 4.10.0
%define adwaita_ver 1.6
%define grilo_ver 0.3.13
%define python_ver 3.7
%define mediaart_ver 1.9.1
%define pygobject_ver 3.50.0
%define pycairo_ver 1.14.0

Requires: python3-module-pygobject3 >= %pygobject_ver
Requires: tracker3 tracker-miners3 >= %tracker_ver typelib(Tracker) = %tracker_api_ver
Requires: grilo-tools >= %grilo_ver grilo-plugins
Requires: gst-plugins-base%gst_api_ver
Requires: typelib(Adw) = 1 typelib(Soup) = %soup_api_ver
Requires: typelib(MediaArt) = 2.0 typelib(GstTag) = %gst_api_ver

BuildRequires(pre): rpm-macros-meson rpm-build-gir rpm-build-python3
BuildRequires: meson %_bindir/git
BuildRequires: yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: libgtk4-devel >= %gtk4_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: libsoup%soup_api_ver-devel
BuildRequires: libgrilo-devel >= %grilo_ver grilo-plugins-devel
BuildRequires: pkgconfig(libmediaart-2.0) >= %mediaart_ver
BuildRequires: gobject-introspection-devel libgtk4-gir-devel
BuildRequires: pkgconfig(tracker-sparql-%tracker_api_ver) >= %tracker_ver
BuildRequires: python3-module-pygobject3-devel >= %pygobject_ver python3-module-pycairo-devel >= %pycairo_ver
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils}

%description
Music playing application for GNOME3.

%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %name %xdg_name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_datadir/%xdg_name/
%_desktopdir/%xdg_name.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/org.gnome.Music.gschema.xml

%_iconsdir/hicolor/*/*/*.svg
%python3_sitelibdir_noarch/gnomemusic/
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc README* NEWS*

%changelog
