%define _unpackaged_files_terminate_build 1
%define ver_major 49
%define beta %nil
%define xdg_name org.gnome.Logs

%def_with man
%def_enable check

Name: gnome-logs
Version: %ver_major.0
Release: alt1%beta

Summary: The GNOME logfile viewer
Group: Graphical desktop/GNOME
License: GPL-3.0
Url: https://apps.gnome.org/Logs

Vcs: https://gitlab.gnome.org/GNOME/gnome-logs.git

Source: %gnome_ftp/%name/%ver_major/%name-%version%beta.tar.xz

Requires: gsettings-desktop-schemas

%define glib_ver 2.44
%define gtk4_ver 4.10
%define adwaita_ver 1.4.0

BuildRequires(pre): rpm-macros-meson rpm-build-gnome
BuildRequires: meson libgio-devel >= %glib_ver
BuildRequires: libgtk4-devel >= %gtk4_ver pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: gsettings-desktop-schemas-devel libsystemd-journal-devel
BuildRequires: yelp-tools desktop-file-utils /usr/bin/appstreamcli
%{?_with_man:BuildRequires: docbook-dtds docbook-style-xsl xsltproc}

%description
GNOME Logs is a log viewer for the systemd journal.

%prep
%setup -n %name-%version%beta

%build
%meson %{?_with_man:-Dman=true}
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_desktopdir/%xdg_name.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/%xdg_name.enums.xml
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_iconsdir/hicolor/*/*/%{xdg_name}*.svg
%_man1dir/%name.1.*
%_datadir/metainfo/%xdg_name.appdata.xml
%doc NEWS README

%changelog
