%def_enable snapshot

%define ver_major 48
%define beta %nil

%def_disable gtk_doc
%def_disable debug
%def_disable valgrind
%def_enable pam
%def_enable selinux
%def_enable systemd
%def_disable ssh
%def_enable man
%def_disable check

Name: gnome-keyring
Version: %ver_major.0
Release: alt1.1%beta

Summary: %name is a password keeper for GNOME
License: GPL-2.0 and LGPL-2.1
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Projects/GnomeKeyring

Vcs: https://gitlab.gnome.org/GNOME/gnome-keyring.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define glib_ver 2.80.0
%define dbus_ver 1.0
%define gcrypt_ver 1.2.2
%define tasn1_ver 0.3.4
%define p11kit_ver 0.23.9
%define gcr_ver 3.28.0

Requires(post): libcap-utils
Requires: p11-kit >= %p11kit_ver

BuildRequires(pre): rpm-macros-meson rpm-macros-pam %{?_enable_systemd:rpm-build-systemd}
BuildRequires: meson libgio-devel >= %glib_ver
BuildRequires: gtk-doc xsltproc
BuildRequires: libdbus-devel >= %dbus_ver
BuildRequires: libgcrypt-devel >= %gcrypt_ver
BuildRequires: libtasn1-devel >= %tasn1_ver  libp11-kit-devel >= %p11kit_ver
BuildRequires: pkgconfig(gcr-base-3) >= %gcr_ver
BuildRequires: libtasn1-utils
BuildRequires: libcap-ng-devel
%{?_enable_pam:BuildRequires: libpam-devel}
%{?_enable_valgrind:BuildRequires: valgrind}
%{?_enable_selinux:BuildRequires: libselinux-devel}
%{?_enable_ssh:BuildRequires: %_bindir/ssh-agent %_bindir/ssh-add}
%{?_enable_check:BuildRequires: /proc xvfb-run dbus-tools-gui}

%description
%name is a program that keep password and other secrets for
users. It is run as a damon in the session, similar to ssh-agent, and
other applications can locate it by an environment variable.

%package -n pam_%name
Summary: A pam module for unlocking keyrings at login time
Group: System/Base
Requires: %name = %EVR

%description -n pam_%name
The pam_gnome-keyring package contains a pam module that can
automatically unlock the "login" keyring when the user logs in
and start the keyring daemon.

%package ssh
Summary: SSH Key Agent for GNOME Keyring
Group: Networking/Remote access
Requires: %name = %EVR
# since 3.27.x gnome-keyring wraps the ssh-agent as a subprocess
Requires: gcr >= %gcr_ver openssh-clients

%description ssh
GNOME Keyring ssh agent is a wrapper for stock ssh-agent from OpenSSH.

%define _gtk_docdir %_datadir/gtk-doc/html
%define _libexecdir %_prefix/libexec/%name

%prep
%setup -n %name-%version%beta

%build
%meson \
    %{subst_enable_meson_bool debug debug-mode} \
    %{subst_enable_meson_feature systemd systemd} \
    %{subst_enable_meson_feature selinux selinux} \
    %{subst_enable_meson_bool pam pam} \
    %{subst_enable_meson_bool ssh ssh-agent} \
    %{subst_enable_meson_bool man manpage}
%nil

%meson_build

%install
%meson_install

%find_lang --with-gnome %name

%check
%__meson_test

%post
setcap -q cap_ipc_lock=ep %_bindir/gnome-keyring-daemon 2>/dev/null ||:

%files -f %name.lang
%_bindir/gnome-keyring
%_bindir/gnome-keyring-3
%_bindir/gnome-keyring-daemon
%_datadir/dbus-1/services/org.gnome.keyring.service
%_datadir/dbus-1/services/org.freedesktop.secrets.service
%_sysconfdir/xdg/autostart/*.desktop
%{?_enable_ssh:%exclude %_sysconfdir/xdg/autostart/gnome-keyring-ssh.desktop}
%_datadir/glib-2.0/schemas/org.gnome.crypto.cache.gschema.xml
%_datadir/GConf/gsettings/org.gnome.crypto.cache.convert
%_datadir/p11-kit/modules/gnome-keyring.module
%_libdir/gnome-keyring/
%{?_enable_ssh:%exclude %_libdir/gnome-keyring/*/gkm-ssh-store-standalone.so}
%_libdir/pkcs11
%{?_enable_man:%_man1dir/*}
%_datadir/dbus-1/services/org.freedesktop.impl.portal.Secret.service
%_datadir/xdg-desktop-portal/portals/gnome-keyring.portal
%{?_enable_systemd:
%_userunitdir/%name-daemon.service
%_userunitdir/%name-daemon.socket}
%doc README NEWS

%if_enabled ssh
%files ssh
%_libdir/gnome-keyring/*/gkm-ssh-store-standalone.so
%_sysconfdir/xdg/autostart/gnome-keyring-ssh.desktop
%endif

%if_enabled pam
%files -n pam_%name
%_pam_modules_dir/pam_gnome_keyring.so
%endif

%changelog
