%define _unpackaged_files_terminate_build 1
%def_disable snapshot
%def_enable check

%define _name nibbles
%define __name gnome-%_name
%define xdg_name org.gnome.Nibbles
%define ver_major 4.4
%define beta %nil
%define _libexecdir %_prefix/libexec

Name: gnome-games-%_name
Version: %ver_major.2
Release: alt1%beta

Summary: Guide a worm around a maze
Group: Games/Boards
License: GPL-3.0-or-later
Url: https://wiki.gnome.org/Apps/Nibbles

Vcs: https://gitlab.gnome.org/GNOME/gnome-nibbles.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%__name/%ver_major/%__name-%version%beta.tar.xz
%else
Source: %__name-%version%beta.tar
%endif

Provides:  %__name = %EVR
Obsoletes: gnome-games-gnibbles
Provides:  gnome-games-gnibbles = %EVR

%define glib_ver 2.78.0
%define gtk_ver 4.15
%define adw_ver 1.5
%define vala_ver 0.56

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson vala-tools >= %vala_ver
BuildRequires: yelp-tools gsettings-desktop-schemas-devel
BuildRequires: desktop-file-utils /usr/bin/appstreamcli
BuildRequires: libgio-devel >= %glib_ver libgtk4-devel >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: pkgconfig(libgnome-games-support-2)
BuildRequires: pkgconfig(gsound)

%description
Control a worm in its quest to eat bonuses and become longer.
Outmaneuver enemy worms while eating apples and bananas to increase your
length. Each worm has six lives and loses one by running into a wall,
another worm, or itself. The enemy worms are after the same bonuses that
you are, so be careful. If the worms become too large, you won't have
much room to move.

%prep
%setup -n %__name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang --all-name --with-gnome %__name

%check
%__meson_test

%files -f gnome-%_name.lang
%_bindir/%__name
%_desktopdir/%xdg_name.desktop
%_datadir/%__name
%_datadir/dbus-1/services/%xdg_name.service
%_iconsdir/hicolor/scalable/apps/%xdg_name.svg
%_iconsdir/hicolor/symbolic/apps/%xdg_name-symbolic.svg
%_man6dir/%__name.*
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc NEWS

%changelog
