%def_disable snapshot
%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec

%define _name mines
%define __name gnome-%_name
%define ver_major 49
%define beta %nil
%define xdg_name org.gnome.Mines

%def_enable check

Name: gnome-games-%_name
Version: %ver_major.0.1
Release: alt1%beta

Summary: Classic find the mines in the minefield game
Group: Games/Boards
License: GPL-3.0-or-later
Url: https://wiki.gnome.org/Apps/Mines

Vcs: https://gitlab.gnome.org/GNOME/gnome-mines.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%__name/%ver_major/%__name-%version%beta.tar.xz
%else
Source: %__name-%version%beta.tar
%endif

Provides:  %__name = %EVR
Obsoletes: gnome-games-gnomine
Provides:  gnome-games-gnomine = %EVR

%define glib_ver 2.40.0
%define gtk_ver 4.20
%define adw_ver 1.8

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson vala-tools yelp-tools
BuildRequires: gsettings-desktop-schemas-devel
BuildRequires: libgio-devel >= %glib_ver libgtk4-devel >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver librsvg-devel
BuildRequires: pkgconfig(gee-0.8)
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils}

%description
NOME Mines is a variation of the popular logic puzzle minesweeper.

%prep
%setup -n %__name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang --all-name --with-gnome %__name

%check
%__meson_test

%files -f gnome-%_name.lang
%_bindir/%__name
%_desktopdir/%xdg_name.desktop
%_datadir/%__name/
%_datadir/dbus-1/services/%xdg_name.service
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_iconsdir/hicolor/*/apps/*.svg
%_man6dir/%__name.*
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc README*

%changelog
