%define _unpackaged_files_terminate_build 1

%define _name lightsoff
%define xdg_name org.gnome.LightsOff
%define ver_major 48
%define beta %nil
%define _libexecdir %_prefix/libexec

%def_enable check

Name: gnome-games-%_name
Version: %ver_major.1
Release: alt1%beta

Summary: Lights Off is a puzzle game
Group: Games/Boards
License: GPL-2.0-or-later
Url: https://wiki.gnome.org/Apps/Lightsoff

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version%beta.tar.xz

Vcs: https://gitlab.gnome.org/GNOME/lightsoff.git

Provides:  %_name = %EVR

%define glib_ver 2.40.0
%define gtk_ver 4.14
%define adw_ver 1.6

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson vala-tools yelp-tools
BuildRequires: libgio-devel >= %glib_ver libgtk4-devel >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: librsvg-devel
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils}

%description
Lights Off is a puzzle game, where the objective is to turn off all of
the tiles on the board. Each click toggles the state of the clicked tile
and its non-diagonal neighbors.

%prep
%setup -n %_name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %_name

%check
%__meson_test

%files -f %_name.lang
%_bindir/%_name
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/*/%{xdg_name}*.*
%_datadir/dbus-1/services/%xdg_name.service
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.metainfo.xml
%_man6dir/%_name.6*

%changelog
