%def_enable snapshot

%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec

%define _name iagno
%define ver_major 3.38
%define xdg_name org.gnome.Reversi

Name: gnome-games-%_name
Version: %ver_major.1
Release: alt3

Summary: Gnome version of Othello (Reversi) board game
Group: Games/Boards
License: GPL-3.0-or-later
Url: https://wiki.gnome.org/Apps/Iagno

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

Provides:  %_name = %version-%release

%define glib_ver 2.40.0
%define gtk_ver 3.22.23

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson vala-tools
BuildRequires: yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: gsettings-desktop-schemas-devel
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver librsvg-devel
BuildRequires: libgsound-devel

%description
Iagno is a computer version of the game Reversi, more popularly called
Othello.

%prep
%setup -n %_name-%version
# comment out duplicate "id" entry from help/LINGUAS
sed -i '0,/^id$/s/\(^id$\)/#\1/' help/LINGUAS

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %_name

%files -f %_name.lang
%attr(-,root,games) %_bindir/%_name
%_desktopdir/%xdg_name.desktop
%_datadir/%_name/
%_iconsdir/hicolor/*/apps/%{xdg_name}*.svg
%_man6dir/%_name.*
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.appdata.xml

%changelog
