%def_disable snapshot
%define _libexecdir %_prefix/libexec
%define nautilus_extdir %_libdir/nautilus/extensions-4

%define _name console
%define ver_major 49
%define beta %nil
%define xdg_name org.gnome.Console
%define binary_name kgx

%def_without nautilus

Name: gnome-%_name
Version: %ver_major.1
Release: alt1%beta

Summary: GNOME Console
License: GPL-3.0-or-later
Group: Terminals
Url: https://apps.gnome.org/Console

Vcs: https://gitlab.gnome.org/GNOME/console.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define glib_ver 2.80
%define pango_ver 1.52
%define gtk4_ver 4.20
%define adwaita_ver 1.8
%define vte_ver 0.77.0
%define nautilus_ver 43

Provides: xvt
Provides: x-terminal-emulator

Requires(pre): libvte3 >= %vte_ver
Requires: dconf

BuildRequires(pre): rpm-macros-meson rpm-macros-alternatives
BuildRequires: meson yelp-tools
BuildRequires: desktop-file-utils %_bindir/appstreamcli
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: pkgconfig(pango) >= %pango_ver
BuildRequires: libgtk4-devel >= %gtk4_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: pkgconfig(libgtop-2.0)
BuildRequires: pkgconfig(vte-2.91-gtk4) >= %vte_ver libpcre2-devel
BuildRequires: gsettings-desktop-schemas-devel
%{?_with_nautilus:BuildRequires: rpm-build-gnome
BuildRequires: pkgconfig(libnautilus-extension-4) >= %nautilus_ver}

%description
A simple user-friendly terminal emulator for the GNOME desktop.

%package nautilus
Summary: Nautilus extension for the GNOME Console
Group: Graphical desktop/GNOME
Requires: %name = %EVR

%description nautilus
This package provides integration with the GNOME Console for the
Nautilus file manager.

%prep
%setup -n %name-%version%beta
%ifarch %ix86 armh
sed -i '/\-Werror=format/d' meson.build
%endif

%build
%meson
%meson_build

%install
%meson_install
# alternatives (xterm -- 40, g-t -- 39, blackbox -- 38)
mkdir -p %buildroot%_altdir
cat >%buildroot%_altdir/%name <<EOF
%_bindir/xvt	%_bindir/%binary_name	37
%_bindir/x-terminal-emulator	%_bindir/%binary_name	37
EOF

%find_lang --with-gnome %binary_name

%files -f %binary_name.lang
%_bindir/%binary_name
%_desktopdir/%xdg_name.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_iconsdir/hicolor/*/apps/%{xdg_name}*.*
%_datadir/metainfo/%xdg_name.metainfo.xml
%_altdir/%name
%doc NEWS README*

%if_with nautilus
%files nautilus
%nautilus_extdir/lib%binary_name-nautilus.so
%endif

%changelog
