%def_disable snapshot

%define _name connections
%define xdg_name org.gnome.Connections
%define ver_major 49
%define beta %nil

%def_enable check

Name: gnome-%_name
Version: %ver_major.0
Release: alt1%beta

Summary: GNOME Connections
Group: Graphical desktop/GNOME
License: GPL-3.0-or-later
Url: https://apps.gnome.org/Connections

Vcs: https://gitlab.gnome.org/GNOME/connections.git

%if_disabled snapshot
Source: https://download.gnome.org/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define glib_ver 2.58
%define gtk_ver 3.22.0
%define handy_ver 1.6
%define fuse_ver 3.9.1
%define freerdp_ver 3.6.3

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson vala-tools yelp-tools
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: pkgconfig(spice-client-gtk-3.0)
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(gtk-vnc-2.0)
# for gtk-frdp
BuildRequires: pkgconfig(freerdp3) >= %freerdp_ver
BuildRequires: pkgconfig(winpr3)
BuildRequires: pkgconfig(libsecret-1)
BuildRequires: gobject-introspection-devel gir(Gtk) = 3.0
BuildRequires: pkgconfig(libhandy-1) >= %handy_ver
BuildRequires: pkgconfig(fuse3) >= %fuse_ver
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils}

%description
%summary

%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_libdir/%name/
%_datadir/applications/%xdg_name.desktop
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/dbus-1/services/%xdg_name.service
%_iconsdir/hicolor/*/*/%{xdg_name}*.*
%_datadir/mime/packages/%xdg_name.xml
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc README* NEWS*

# gtk-frdp usless stuff
%exclude %_includedir/%name/
%exclude %_datadir/%name/
%exclude %_libdir/%name/girepository-1.0/
%exclude %_libdir/%name/pkgconfig/

%changelog
