%def_enable snapshot
%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec

%define ver_major 3.36
%define xdg_name org.gnome.ColorProfileViewer

# tests require colord running and g-c-m installed
%def_disable check

Name: gnome-color-manager
Version: %ver_major.2
Release: alt2

Summary: Color profile manager for the GNOME desktop
License: GPL-2.0-or-later
Group: Graphical desktop/GNOME
Url: https://gitlab.gnome.org/GNOME/gnome-color-manager

Vcs: https://gitlab.gnome.org/GNOME/gnome-color-manager.git

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Obsoletes: libcolor-glib
Requires: common-licenses gnome-filesystem
Requires: colord icc-profiles

%define gio_ver 2.31.10
%define gtk_ver 3.4
%define colord_ver 1.3.1
%define colord_gtk_ver 0.1.20
%define lcms_ver 2.2

BuildRequires(pre): rpm-macros-meson rpm-build-gnome
BuildRequires: meson gcc-c++ yelp-tools /usr/bin/appstream-util
BuildRequires: docbook-utils xsltproc
BuildRequires: libgio-devel >= %gio_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: colord-devel >= %colord_ver
BuildRequires: libcolord-gtk-devel >= %colord_gtk_ver
BuildRequires: liblcms2-devel >= %lcms_ver libXrandr-devel
%{?_enable_check:BuildRequires: /proc xvfb-run}

%description
gnome-color-manager is a session program that makes it easy to manage,
install and generate color profiles in the GNOME desktop.

This project has the following features:

* Setting output gamma tables (with local brightness and adjustments) to any
  Xrandr output (falling back to the per-screen methods for drivers that do not
  yet support Xrandr 1.3).

* Setting of settings at session start, and when monitors are hotplugged.

* Easy install of vendor supplied ICC or ICM files, just by double clicking
  on the file.

* Easy display calibration using an external calibration device, and scanner
  calibration using a inexpensive IT 8.7 target. For calibration, the ArgyllCMS
  package is required.

* Integration X11 by setting the per-screen and per-output _ICC_PROFILE atom,
  which makes applications such as the GIMP use a color managed output.

* Easy to use DBus interface for applications to query what ICC profiles should
  be used for a specific device. This is session activated and is only started
  when it is needed, and quits after a small period of idleness.

%prep
%setup

%build
%meson \
    -Dtests=true \
    %{subst_enable_meson_bool packagekit packagekit}
%meson_build

%install
%meson_install
# The license
ln -sf %_licensedir/GPL-2 COPYING

%find_lang --with-gnome %name

%check
%__meson_test

%files -f %name.lang
%_bindir/gcm-import
%_bindir/gcm-inspect
%_bindir/gcm-picker
%_bindir/gcm-viewer
%_datadir/%name/
%_desktopdir/%xdg_name.desktop
%_desktopdir/gcm-import.desktop
%_desktopdir/gcm-picker.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_iconsdir/hicolor/*x*/apps/*.png
%_iconsdir/hicolor/scalable/apps/*.svg
%_man1dir/*
%_datadir/metainfo/%xdg_name.appdata.xml
%doc --no-dereference COPYING
%doc README AUTHORS

%changelog
