%def_disable snapshot
# experimental
%def_enable gimp_plugin
%{?_enable_gimp_plugin:%define gimpplugindir %(gimptool-3.0 --gimpplugindir)}
%define gimpplugindir %_libdir/gimp/3.0
%def_enable zart
%ifarch %e2k
# it's impossible to use such a bad OpenMP implementation for such complex code
%def_disable openmp
%else
%def_enable openmp
%endif

# https://github.com/GreycLab/zart
# no tags
%define zart_ver d014169
# https://github.com/GreycLab/gmic-qt
%define gmic_qt_ver v.3.5.0-7-gb55b8ca
# https://github.com/GreycLab/gmic-community.git
%define gmic_comm_ver gmic-3.4.3-314-gea62768f

Name: gmic
Version: 3.6.4
Release: alt1

Summary: GREYC's Magic Image Converter
License: CECILL-2.0 and GPL-3.0
Group: Graphics
Url: https://gmic.eu

Vcs: https://github.com/GreycLab/gmic.git

%if_disabled snapshot
Source: http://gmic.eu/files/source/%{name}_%version.tar.gz
%else
Source: %name-%version.tar
%endif
Source1: zart-%zart_ver.tar
Source2: gmic-qt-%gmic_qt_ver.tar
Source3: gmic-community-%gmic_comm_ver.tar

Requires: lib%name = %EVR

BuildRequires: dos2unix
BuildRequires: gcc-c++ imake libGraphicsMagick-c++-devel libImageMagick-devel libXext-devel libXrandr-devel
BuildRequires: libavformat-devel libfftw3-devel libjpeg-devel libopencv-devel libpng-devel
BuildRequires: libwebp-devel
BuildRequires: libswscale-devel libtiff-devel openexr-devel xorg-cf-files zlib-devel
%{?_enable_openmp:BuildRequires: libgomp-devel}
BuildRequires: libcurl-devel
BuildRequires: bash-completion
%{?_enable_gimp_plugin:BuildRequires: libgimp-devel}
# for qt
BuildRequires(pre): rpm-macros-qt5
BuildRequires: qt5-base-devel qt5-tools-devel
%if_enabled zart
BuildRequires(pre): rpm-macros-qt5
BuildRequires: qt5-base-devel qt5-tools-devel
%endif

%description
G'MIC (GREYC's Magic Image Converter) is an interpreter of image processing
macros whose goal is to convert, manipulate and visualize generic 1D/2D/3D
multi-spectral image datasets.

%package -n lib%name
Summary: GREYC's Magic Image Converter Library
Group: System/Libraries

%description -n lib%name
G'MIC (GREYC's Magic Image Converter) is an interpreter of image processing
macros whose goal is to convert, manipulate and visualize generic 1D/2D/3D
multi-spectral image datasets.

This package provides shared G'MIC library.

%package -n lib%name-devel
Summary: GREYC's Magic Image Converter Library (development package)
Group: Development/C++
Requires: lib%name = %EVR

%description -n lib%name-devel
G'MIC (GREYC's Magic Image Converter) is an interpreter of image processing
macros whose goal is to convert, manipulate and visualize generic 1D/2D/3D
multi-spectral image datasets.

This package provides development files for GREYC's Magic Image Converter Library.

%package zart
Summary: GREYC's image processing language demo
Group: Graphics
Provides: zart = %EVR
Requires: lib%name = %EVR
Requires: gst-libav

%description zart
ZArt is a computer program whose purpose is to demonstrate the possibilities of
the G'MIC image processing language by offering the choice of several
manipulations on a video stream acquired from a webcam. In other words, ZArt is
a GUI for G'MIC real-time manipulations on the output of a webcam.

%package qt
Summary: Qt-based frontend for G'MIC
Group: Graphics
Requires: %name = %EVR

%description qt
G'MIC-Qt is a versatile front-end to the image processing framework
G'MIC. It is in fact a plugin for GIMP and Krita, as well as a standalone
application.

%package -n gimp-plugin-gmic
Summary: Image denoising and interpolation plugin for GIMP
Group: Graphics
Requires: gimp

%description -n gimp-plugin-gmic
G'MIC (GREYC's Magic Image Converter) is an interpreter of image processing
macros whose goal is to convert, manipulate and visualize generic 1D/2D/3D
multi-spectral image datasets.

%prep
%setup -n gmic-%version -a1 -a2 -a3
%if_disabled openmp
sed -i "s|-fopenmp -Dcimg_use_openmp||;s|-lgomp||" src/Makefile
sed -i "s|cimg_use_openmp||;s|-fopenmp||" gmic-qt/gmic_qt.pro zart/zart.pro
%endif

dos2unix src/Makefile
# fix libdir
sed -i 's|\$(USR)/\$(LIB)/|$(USR)/%_lib/|' src/Makefile
sed -i 's|\$(PREFIX)/\$(LIB)/|$(PREFIX)/%_lib/|' src/Makefile
# fix libcgmic path
subst 's| \.\.\/\(\.\.\/gmic-community/libcgmic\)| \1|' src/Makefile
%ifnarch %ix86 x86_64
sed -i 's|-mtune=generic||' src/Makefile
%endif
# remove unusual rpath
sed -i 's|-Wl,-rpath,.||' src/Makefile

%build
%add_optflags %(getconf LFS_CFLAGS)
pushd src
%make V=1 NOSTRIP=1 OPT_CFLAGS="%optflags" cli lib libc
popd

pushd %name-qt
%define opt_qt CONFIG+=release GMIC_PATH=../src NOSTRIP=1
%qmake_qt5 %opt_qt HOST=none gmic_qt.pro
%make_build
%{?_enable_gimp_plugin:%qmake_qt5 %opt_qt HOST=gimp3 gmic_qt.pro
%make_build}
#%%cmake
#%%cmake_build
popd

%if_enabled zart
pushd zart
rm -f .qmake.stash
%qmake_qt5 CONFIG+=release GMIC_PATH=../src zart.pro
%make_build
popd
%endif

%install
cp -f gmic-community/libcgmic/COPYING COPYING-libcgmic
mkdir -p %buildroot%_libdir

pushd src
%makeinstall_std
popd

pushd %name-qt
%makeinstall_std
popd

%if_enabled zart
pushd zart
#%%makeinstall_std
%make INSTALL_ROOT=%buildroot install
popd
%endif

%find_lang --with-man %name

%files -f %name.lang
%_bindir/%name
%_man1dir/%name.1*
%_datadir/%name/
%_datadir/bash-completion/completions/%name
%doc README COPYING

%files qt
%_bindir/%{name}_qt
%_desktopdir/gmic_qt.desktop
%_iconsdir/hicolor/*x*/apps/gmic_qt.png
%_iconsdir/hicolor/scalable/apps/gmic_qt.svg
%doc %name-qt/README*

%files -n lib%name
%_libdir/lib%name.so.*
%_libdir/libc%name.so.*
%doc COPYING COPYING-libcgmic

%files -n lib%name-devel
%_includedir/gmic.h
%_includedir/gmic_libc.h
%_libdir/lib%name.so
%_libdir/libc%name.so

%if_enabled zart
%files zart
%_bindir/zart
%_desktopdir/zart.desktop
%_iconsdir/hicolor/*x*/apps/zart.png
%_iconsdir/hicolor/scalable/apps/zart.svg
%doc zart/README* zart/Licence_CeCILL_V2*
%endif

%{?_enable_gimp_plugin:
%files -n gimp-plugin-gmic
%gimpplugindir/plug-ins/*}

%changelog
