%def_disable snapshot

%define ver_major 2.80
%define beta %nil
%define _libexecdir %_prefix/libexec
%define _userunitdir %(pkg-config systemd --variable systemduserunitdir)

# Only one TLS or SSL can be enabled
%def_enable tls
%def_disable ssl

%def_enable libproxy
%def_enable gnome_proxy
%def_enable environment_proxy
%def_enable installed_tests
%def_disable check

Name: glib-networking
Version: %ver_major.1
Release: alt1%beta

Summary: Networking support for GIO
Group: System/Libraries
License: LGPL-2.0-or-later
Url: https://www.gnome.org

Vcs: https://gitlab.gnome.org/GNOME/glib-networking

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

%{?_enable_gnome_proxy:Requires: gsettings-desktop-schemas >= 3.2.0}
Requires: ca-certificates

%define glib_ver 2.73.3
%define gnutls_ver 3.7.4
%define p11kit_ver 0.20
%define libproxy_ver 0.4.16

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson libgio-devel >= %glib_ver pkgconfig(systemd)
%{?_enable_ssl:BuildRequires: libssl-devel}
%{?_enable_gnome_proxy:BuildRequires: gsettings-desktop-schemas-devel}
%{?_enable_tls:BuildRequires: libgnutls-devel >= %gnutls_ver libgcrypt-devel}
%{?_enable_pkcs11:BuildRequires: libp11-kit-devel >= %p11kit_ver ca-certificates}
%{?_enable_libproxy:BuildRequires: libproxy-devel >= %libproxy_ver}
%{?_enable_installed_tests:
BuildRequires(pre): rpm-build-python3
%add_python3_path %_libexecdir/installed-tests/%name}

%description
This package contains modules that extend the networking support in GIO.
In particular, it contains a libproxy-based GProxyResolver implementation
and a gnutls-based GTlsConnection implementation.

%package -n glib-openssl
Summary: Network-related giomodule for glib using openssl
Group: System/Libraries

%description -n glib-openssl
This package contains the implementations of certain GLib openssl
features that cannot be implemented directly in GLib itself because of
their dependencies

%package tests
Summary: Tests for the %name package
Group: Development/Other
Requires: %name = %EVR

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed %name package.


%prep
%setup -n %name-%version%beta

%build
%meson \
    %{subst_enable_meson_feature tls gnutls} \
    %{subst_enable_meson_feature ssl openssl} \
    %{subst_enable_meson_feature libproxy libproxy} \
    %{subst_enable_meson_feature gnome_proxy gnome_proxy} \
    %{subst_enable_meson_feature environment_proxy environment_proxy} \
    %{subst_enable_meson_bool installed_tests installed_tests}
%nil
%meson_build

%install
%meson_install
%find_lang %name

%check
%__meson_test

%files -f %name.lang
%{?_enable_tls:%_libdir/gio/modules/libgiognutls.so}
%{?_enable_gnome_proxy:%_libdir/gio/modules/libgiognomeproxy.so}
%{?_enable_environment_proxy:%_libdir/gio/modules/libgioenvironmentproxy.so}
%if_enabled libproxy
%_libdir/gio/modules/libgiolibproxy.so
%_libexecdir/glib-pacrunner
%_datadir/dbus-1/services/org.gtk.GLib.PACRunner.service
%_userunitdir/glib-pacrunner.service
%endif
%doc NEWS README

%if_enabled ssl
%files -n glib-openssl
%_libdir/gio/modules/libgioopenssl.so
%doc NEWS README
%endif

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%name/
%_datadir/installed-tests/%name/
%endif

%changelog
