%define _unpackaged_files_terminate_build 1
%def_with check
%ifarch %e2k
# uvicorn unavailable on elbrus (due to greenlet)
%def_without webserver
%else
%def_with webserver
%endif

Name: glances
Version: 4.3.0.8
Release: alt1.2

Summary: CLI curses based monitoring tool
License: GPLv3
Group: Monitoring
Url: https://github.com/nicolargo/glances
BuildArch: noarch

Source: %name-%version.tar
Source1: .gear/glances-webserver.service
Source2: .gear/glances.env
Patch0: %name-%version-alt.patch
# see https://github.com/nicolargo/glances/pull/3106
Patch1: glances-4.3.0.8-alt-fix-config-path.patch

Requires: python3-module-%name = %EVR

#skip findreq for optional dependencies from exports
%add_findreq_skiplist %python3_sitelibdir/%name/exports/*.py

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-defusedxml
BuildRequires: python3-module-dateutil
BuildRequires: python3-module-ujson
BuildRequires: python3-module-psutil
BuildRequires: /proc

%if_with webserver
BuildRequires: python3-module-fastapi
BuildRequires: python3-module-uvicorn
BuildRequires: python3-module-jinja2
%endif

%if_with check
BuildRequires: python3-module-selenium
BuildRequires: python3-module-pytest
%endif

%description
Glances is a CLI curses based monitoring tool for both GNU/Linux and BSD.

Glances uses the PsUtil library to get information from your system.

%package -n python3-module-%name
Summary: CLI curses based monitoring tool
Group: Development/Python3
Requires: python3(defusedxml.xmlrpc)

%description -n python3-module-%name
Glances is a CLI curses based monitoring tool for both GNU/Linux and BSD.

Glances uses the PsUtil library to get information from your system.

%package webserver
Summary: CLI curses based monitoring tool web server
Group: Monitoring
Requires: python3-module-fastapi
Requires: python3-module-uvicorn
Requires: python3-module-jinja2
Requires: %name = %EVR

%description webserver
%summary.

%prep
%setup

%patch0 -p1
%patch1 -p1

%build
%pyproject_build

%install
%pyproject_install
install -D -p -m 644 conf/glances.conf %buildroot%_sysconfdir/%name/glances.conf
%if_with webserver
# Create and install empty password file so glances-webserver.service won't ask
# for CLI input when run with --password flag
touch glances.pwd
install -D -p -m 660 glances.pwd %buildroot%_sharedstatedir/%name/.config/glances/glances.pwd
install -D -p -m 644 %SOURCE1 %buildroot%_unitdir/glances-webserver.service
install -D -p -m 644 %SOURCE2 %buildroot%_sysconfdir/%name/glances.env
%endif

%check
# see .github/workflows/test.yml
%pyproject_run_pytest ./tests/test_core.py

%pre webserver
%_sbindir/groupadd -r -f %name 2>/dev/null ||:
%_sbindir/useradd -r -g %name -d %_sharedstatedir/%name \
  -s /dev/null %name >/dev/null 2>&1 ||:

%post webserver
%post_service glances-webserver

%preun webserver
%preun_service glances-webserver

%files
%doc AUTHORS COPYING README.rst NEWS.rst
%_bindir/glances
%_man1dir/glances.1*
%_docdir/glances/
%dir %_sysconfdir/glances
%config(noreplace) %_sysconfdir/glances/glances.conf

%files -n python3-module-%name
%python3_sitelibdir/glances
%python3_sitelibdir/%{pyproject_distinfo %name}/

%if_with webserver
%files webserver
%_unitdir/glances-webserver.service
%config(noreplace) %_sysconfdir/%name/glances.env
%dir %attr(770,root,%name) %_sharedstatedir/%name
%dir %attr(770,root,%name) %_sharedstatedir/%name/.config
%dir %attr(770,root,%name) %_sharedstatedir/%name/.config/glances
%config(noreplace) %attr(660,root,%name) %_sharedstatedir/%name/.config/glances/glances.pwd
%endif

%changelog
