%define _unpackaged_files_terminate_build 1
%define import_path gitlab.com/gitlab-org/cli

%define bash_completionsdir %_datadir/bash-completion/completions
%define fish_completionsdir %_datadir/fish/vendor_completions.d
%define zsh_completionsdir %_datadir/zsh/site-functions

%def_with docs

Name: glab
Version: 1.74.0
Release: alt1

Summary: A GitLab CLI tool bringing GitLab to your command line
License: MIT
Group: Development/Other
Url: https://gitlab.com/gitlab-org/cli
Vcs: https://gitlab.com/gitlab-org/cli

ExclusiveArch: %go_arches

Source0: %name-%version.tar
Source1: %name-%version-vendor.tar
Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-build-golang
%if_with docs
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-sphinx_rtd_theme
%endif

%description
GLab is an open source GitLab CLI tool bringing GitLab to your terminal
next to where you are already working with git and your code without
switching between windows and browser tabs. Work with issues, merge
requests, watch running pipelines directly from your CLI among other
features.

glab is available for repositories hosted on GitLab.com and self-managed
GitLab instances. glab supports multiple authenticated GitLab instances
and automatically detects the authenticated hostname from the remotes
available in the working Git directory.

%package docs
Summary: Documentation for glab (in man-pages and markdown formats)
Group: Documentation
BuildArch: noarch

%description docs
%summary.

%prep
%setup -a1
%autopatch -p1

%build
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"
%golang_prepare

pushd .build/src/%import_path
    export LDFLAGS="$LDFLAGS -X main.buildDate=$(date +%%Y-%%m-%%d)"
    export LDFLAGS="$LDFLAGS -X main.version=%version"
    %golang_build cmd/glab
popd

%if_with docs
go run ./cmd/gen-docs/docs.go --manpage --path .man-pages/
go run ./cmd/gen-docs/docs.go --path .web-pages/
%endif

%install
export BUILDDIR="$PWD/.build"
export IGNORE_SOURCES=1
%golang_install

mkdir -p %buildroot%_man1dir
mv .man-pages/* %buildroot%_man1dir

mkdir -p %buildroot%bash_completionsdir
mkdir -p %buildroot%fish_completionsdir
mkdir -p %buildroot%zsh_completionsdir

%buildroot%_bindir/%name completion -s bash > %buildroot%bash_completionsdir/%name
%buildroot%_bindir/%name completion -s fish > %buildroot%fish_completionsdir/%name.fish
%buildroot%_bindir/%name completion -s zsh > %buildroot%zsh_completionsdir/_%name

%files
%doc LICENSE README.md
%_bindir/%name
%bash_completionsdir/%name
%fish_completionsdir/%name.fish
%zsh_completionsdir/_%name

%files docs
%doc .web-pages/*
%exclude %_docdir/%name-%version/LICENSE
%exclude %_docdir/%name-%version/README.md
%_man1dir/*.1.*

%changelog
